/*
 * Decompiled with CFR 0.152.
 */
package sen.manaita_plus.common.item.tool;

import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.Nullable;
import sen.manaita_plus.common.item.data.IManaitaPlusDestroy;
import sen.manaita_plus.common.item.data.IManaitaPlusKey;
import sen.manaita_plus.common.util.ManaitaPlusText;
import sen.manaita_plus.common.util.ManaitaPlusUtils;

public class ManaitaPlusShearsItem
extends ShearsItem
implements IManaitaPlusKey,
IManaitaPlusDestroy {
    public ManaitaPlusShearsItem() {
        super(new Item.Properties().m_41487_(1).m_41503_(-1).m_41486_());
    }

    public boolean m_8096_(BlockState p_43087_) {
        return p_43087_.m_60713_(Blocks.f_50033_) || p_43087_.m_60713_(Blocks.f_50088_) || p_43087_.m_60713_(Blocks.f_50267_);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_SHEARS_ACTIONS.contains(toolAction);
    }

    public float m_8102_(ItemStack p_43084_, BlockState p_43085_) {
        if (!(p_43085_.m_60713_(Blocks.f_50033_) || p_43085_.m_204336_(BlockTags.f_13035_) || p_43085_.m_60713_(Blocks.f_50191_) || p_43085_.m_60713_(Blocks.f_152475_) || p_43085_.m_204336_(BlockTags.f_13089_))) {
            return super.m_8102_(p_43084_, p_43085_);
        }
        return Float.POSITIVE_INFINITY;
    }

    public InteractionResult m_6880_(ItemStack stack, Player playerIn, LivingEntity entity, InteractionHand hand) {
        if (entity instanceof IForgeShearable) {
            IForgeShearable target = (IForgeShearable)entity;
            if (entity.m_9236_().f_46443_) {
                return InteractionResult.SUCCESS;
            }
            BlockPos pos = BlockPos.m_274446_((Position)entity.m_20182_());
            if (target.isShearable(stack, entity.m_9236_(), pos)) {
                List drops = target.onSheared(playerIn, stack, entity.m_9236_(), pos, EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)stack));
                Random rand = new Random();
                drops.forEach(d -> {
                    ItemEntity ent = entity.m_5552_(d, 1.0f);
                    ent.m_20256_(ent.m_20184_().m_82520_((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
                });
                stack.m_41622_(1, (LivingEntity)playerIn, e -> e.m_21190_(hand));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResult m_6225_(UseOnContext p_186371_) {
        GrowingPlantHeadBlock growingplantheadblock;
        BlockPos blockpos;
        Level level = p_186371_.m_43725_();
        BlockState blockstate = level.m_8055_(blockpos = p_186371_.m_8083_());
        Block block = blockstate.m_60734_();
        if (block instanceof GrowingPlantHeadBlock && !(growingplantheadblock = (GrowingPlantHeadBlock)block).m_187440_(blockstate)) {
            Player player = p_186371_.m_43723_();
            ItemStack itemstack = p_186371_.m_43722_();
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10562_.m_285767_((ServerPlayer)player, blockpos, itemstack);
            }
            level.m_5594_(player, blockpos, SoundEvents.f_184217_, SoundSource.BLOCKS, 1.0f, 1.0f);
            BlockState blockstate1 = growingplantheadblock.m_187438_(blockstate);
            level.m_46597_(blockpos, blockstate1);
            level.m_220407_(GameEvent.f_157792_, blockpos, GameEvent.Context.m_223719_((Entity)p_186371_.m_43723_(), (BlockState)blockstate1));
            if (player != null) {
                itemstack.m_41622_(1, (LivingEntity)player, p_186374_ -> p_186374_.m_21190_(p_186371_.m_43724_()));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6225_(p_186371_);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level p_41432_, Player p_41433_, InteractionHand p_41434_) {
        ItemStack itemInHand = p_41433_.m_21120_(p_41434_);
        if (!p_41432_.f_46443_) {
            if (p_41433_.m_6144_()) {
                this.setRange(itemInHand, (this.getRange(itemInHand) + 2) % 21);
            } else {
                HashMap<Enchantment, Integer> enchantmentMap = new HashMap<Enchantment, Integer>();
                enchantmentMap.put(Enchantments.f_44987_, 10);
                String s = I18n.m_118938_((String)"enchantments.fortune", (Object[])new Object[0]);
                if (!EnchantmentHelper.m_272262_((ItemStack)itemInHand)) {
                    enchantmentMap.put(Enchantments.f_44985_, 1);
                    s = I18n.m_118938_((String)"enchantments.silktouch", (Object[])new Object[0]);
                }
                EnchantmentHelper.m_44865_(enchantmentMap, (ItemStack)itemInHand);
                ManaitaPlusUtils.chat((Component)Component.m_237113_((String)ManaitaPlusText.manaita_enchantment.formatting(itemInHand.m_41611_().getString() + I18n.m_118938_((String)"info.enchantment", (Object[])new Object[0]) + ": " + s)));
            }
        }
        return InteractionResultHolder.m_19098_((Object)itemInHand);
    }

    @Override
    public int getRange(ItemStack itemStack) {
        int range;
        if (itemStack.m_41783_() == null) {
            itemStack.m_41751_(new CompoundTag());
        }
        if ((range = itemStack.m_41783_().m_128451_("Range")) == 0) {
            itemStack.m_41783_().m_128405_("Range", 1);
            return 1;
        }
        return range;
    }

    public void setRange(ItemStack itemStack, int range) {
        if (range == 0) {
            range = 1;
        }
        itemStack.m_41783_().m_128405_("Range", range);
        ManaitaPlusUtils.chat((Component)Component.m_237113_((String)ManaitaPlusText.manaita_mode.formatting("[" + I18n.m_118938_((String)"item.manaita_plus.manaita_shears", (Object[])new Object[0]) + "] " + I18n.m_118938_((String)"mode.range.name", (Object[])new Object[0]) + ": " + range + "x" + range + "x" + range)));
    }

    public void m_7373_(ItemStack p_41421_, @Nullable Level p_41422_, List<Component> p_41423_, TooltipFlag p_41424_) {
        super.m_7373_(p_41421_, p_41422_, p_41423_, p_41424_);
        String range = String.valueOf(this.getRange(p_41421_));
        p_41423_.add((Component)Component.m_237113_((String)ManaitaPlusText.manaita_mode.formatting(I18n.m_118938_((String)"mode.manaita_tool", (Object[])new Object[0]) + ": " + range + "x" + range + "x" + range)));
        p_41423_.add((Component)Component.m_237113_((String)ManaitaPlusText.manaita_mode.formatting(I18n.m_118938_((String)"mode.doubling", (Object[])new Object[0]) + ":" + (ManaitaPlusShearsItem.getDoubling(p_41421_) ? I18n.m_118938_((String)"info.on", (Object[])new Object[0]) : I18n.m_118938_((String)"info.off", (Object[])new Object[0])))));
    }

    @Override
    public void onManaitaKeyPress(ItemStack itemStack, Player player) {
        boolean doubling = !ManaitaPlusShearsItem.getDoubling(itemStack);
        ManaitaPlusShearsItem.setDoubling(itemStack, doubling);
        Minecraft.m_91087_().f_91065_.m_93063_((Component)Component.m_237113_((String)String.format("[%s%s] %s%s: %s", ManaitaPlusText.manaita_mode.formatting(I18n.m_118938_((String)"item.manaita_bow.name", (Object[])new Object[0])), ChatFormatting.RESET, ChatFormatting.RESET, I18n.m_118938_((String)"mode.manaita_sword_god", (Object[])new Object[0]), ManaitaPlusShearsItem.getDoubling(itemStack) ? I18n.m_118938_((String)"info.on", (Object[])new Object[0]) : I18n.m_118938_((String)"info.off", (Object[])new Object[0]))), false);
    }

    public static boolean getDoubling(ItemStack itemStack) {
        if (itemStack.m_41783_() == null) {
            itemStack.m_41751_(new CompoundTag());
        }
        return itemStack.m_41783_().m_128471_("Doubling");
    }

    public static void setDoubling(ItemStack itemStack, boolean invisibility) {
        if (itemStack.m_41783_() == null) {
            itemStack.m_41751_(new CompoundTag());
        }
        itemStack.m_41783_().m_128379_("Doubling", invisibility);
    }

    @Override
    public boolean accept(BlockState state) {
        return state.m_204336_(BlockTags.f_144280_);
    }
}

