/*
 * Decompiled with CFR 0.152.
 */
package sen.manaita_plus.common.network.data;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;
import sen.manaita_plus.common.item.data.IManaitaPlusDestroy;
import sen.manaita_plus.common.util.ManaitaPlusUtils;

public class MessageDestroy {
    private final BlockPos blockPos;
    private final int range;
    private final Item item;

    public MessageDestroy(FriendlyByteBuf buffer) {
        this.blockPos = buffer.m_130135_();
        this.range = buffer.readInt();
        this.item = (Item)buffer.m_236816_((IdMap)BuiltInRegistries.f_257033_);
    }

    public MessageDestroy(BlockPos blockPos, int range, Item item) {
        this.blockPos = blockPos;
        this.range = range;
        this.item = item;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.blockPos);
        buf.writeInt(this.range);
        buf.m_236818_((IdMap)BuiltInRegistries.f_257033_, (Object)this.item);
    }

    public void handler(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Minecraft mc = Minecraft.m_91087_();
            ClientLevel level = mc.f_91073_;
            if (level == null || mc.f_91074_ == null) {
                return;
            }
            Item patt1766$temp = this.item;
            if (patt1766$temp instanceof IManaitaPlusDestroy) {
                IManaitaPlusDestroy des = (IManaitaPlusDestroy)patt1766$temp;
                int xM = this.blockPos.m_123341_() + this.range;
                int yM = this.blockPos.m_123342_() + this.range;
                int zM = this.blockPos.m_123343_() + this.range;
                BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
                for (int x = this.blockPos.m_123341_() - this.range; x <= xM; ++x) {
                    for (int y = this.blockPos.m_123342_() - this.range; y <= yM; ++y) {
                        for (int z = this.blockPos.m_123343_() - this.range; z <= zM; ++z) {
                            BlockState blockState = level.m_8055_((BlockPos)mutableBlockPos.m_122178_(x, y, z));
                            if (blockState == null || !des.accept(blockState)) continue;
                            ManaitaPlusUtils.setBlock((Level)level, (BlockPos)mutableBlockPos, level.m_6425_((BlockPos)mutableBlockPos).m_76188_());
                            SoundType soundtype = blockState.getSoundType((LevelReader)level, (BlockPos)mutableBlockPos, (Entity)mc.f_91074_);
                            mc.m_91106_().m_120367_((SoundInstance)new SimpleSoundInstance(soundtype.m_56778_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 8.0f, soundtype.m_56774_() * 0.5f, SoundInstance.m_235150_(), (BlockPos)mutableBlockPos));
                        }
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

