/*
 * Decompiled with CFR 0.152.
 */
package sen.manaita_plus.common.recipe;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.IShapedRecipe;
import org.jetbrains.annotations.Nullable;
import sen.manaita_plus.common.core.ManaitaPlusRecipeSerializerCore;

public class ManaitaPlusNBTCraftingRecipe
implements CraftingRecipe,
IShapedRecipe<CraftingContainer> {
    static int MAX_WIDTH = 3;
    static int MAX_HEIGHT = 3;
    final int width;
    final int height;
    final NonNullList<Ingredient> recipeItems;
    final ItemStack result;
    private final ResourceLocation id;
    final String group;
    final CraftingBookCategory category;
    final boolean showNotification;

    public static void setCraftingSize(int width, int height) {
        if (MAX_WIDTH < width) {
            MAX_WIDTH = width;
        }
        if (MAX_HEIGHT < height) {
            MAX_HEIGHT = height;
        }
    }

    public ManaitaPlusNBTCraftingRecipe(ResourceLocation p_273203_, String p_272759_, CraftingBookCategory p_273506_, int p_272952_, int p_272920_, NonNullList<Ingredient> p_273650_, ItemStack p_272852_, boolean p_273122_) {
        this.id = p_273203_;
        this.group = p_272759_;
        this.category = p_273506_;
        this.width = p_272952_;
        this.height = p_272920_;
        this.recipeItems = p_273650_;
        this.result = p_272852_;
        this.showNotification = p_273122_;
    }

    public ManaitaPlusNBTCraftingRecipe(ResourceLocation p_250963_, String p_250221_, CraftingBookCategory p_250716_, int p_251480_, int p_251980_, NonNullList<Ingredient> p_252150_, ItemStack p_248581_) {
        this(p_250963_, p_250221_, p_250716_, p_251480_, p_251980_, p_252150_, p_248581_, true);
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ManaitaPlusRecipeSerializerCore.CraftingRecipeType.get();
    }

    public String m_6076_() {
        return this.group;
    }

    public CraftingBookCategory m_245232_() {
        return this.category;
    }

    public ItemStack m_8043_(RegistryAccess p_266881_) {
        return this.result;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.recipeItems;
    }

    public boolean m_271738_() {
        return this.showNotification;
    }

    public boolean m_8004_(int p_44161_, int p_44162_) {
        return p_44161_ >= this.width && p_44162_ >= this.height;
    }

    public boolean matches(CraftingContainer p_44176_, Level p_44177_) {
        for (int i = 0; i <= p_44176_.m_39347_() - this.width; ++i) {
            for (int j = 0; j <= p_44176_.m_39346_() - this.height; ++j) {
                if (this.matches(p_44176_, i, j, true)) {
                    return true;
                }
                if (!this.matches(p_44176_, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matches(CraftingContainer p_44171_, int p_44172_, int p_44173_, boolean p_44174_) {
        for (int i = 0; i < p_44171_.m_39347_(); ++i) {
            for (int j = 0; j < p_44171_.m_39346_(); ++j) {
                int k = i - p_44172_;
                int l = j - p_44173_;
                Ingredient ingredient = Ingredient.f_43901_;
                if (k >= 0 && l >= 0 && k < this.width && l < this.height) {
                    ingredient = p_44174_ ? (Ingredient)this.recipeItems.get(this.width - k - 1 + l * this.width) : (Ingredient)this.recipeItems.get(k + l * this.width);
                }
                if (ingredient.test(p_44171_.m_8020_(i + j * p_44171_.m_39347_()))) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack assemble(CraftingContainer p_266686_, RegistryAccess p_266725_) {
        return this.m_8043_(p_266725_).m_41777_();
    }

    public int getWidth() {
        return this.width;
    }

    public int getRecipeWidth() {
        return this.getWidth();
    }

    public int getHeight() {
        return this.height;
    }

    public int getRecipeHeight() {
        return this.getHeight();
    }

    static NonNullList<Ingredient> dissolvePattern(String[] p_44203_, Map<String, Ingredient> p_44204_, int p_44205_, int p_44206_) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)(p_44205_ * p_44206_), (Object)Ingredient.f_43901_);
        HashSet set = Sets.newHashSet(p_44204_.keySet());
        set.remove(" ");
        for (int i = 0; i < p_44203_.length; ++i) {
            for (int j = 0; j < p_44203_[i].length(); ++j) {
                String s = p_44203_[i].substring(j, j + 1);
                Ingredient ingredient = p_44204_.get(s);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + s + "' but it's not defined in the key");
                }
                set.remove(s);
                nonnulllist.set(j + p_44205_ * i, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return nonnulllist;
    }

    @VisibleForTesting
    static String[] shrink(String ... p_44187_) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int i1 = 0; i1 < p_44187_.length; ++i1) {
            String s = p_44187_[i1];
            i = Math.min(i, ManaitaPlusNBTCraftingRecipe.firstNonSpace(s));
            int j1 = ManaitaPlusNBTCraftingRecipe.lastNonSpace(s);
            j = Math.max(j, j1);
            if (j1 < 0) {
                if (k == i1) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (p_44187_.length == l) {
            return new String[0];
        }
        String[] astring = new String[p_44187_.length - l - k];
        for (int k1 = 0; k1 < astring.length; ++k1) {
            astring[k1] = p_44187_[k1 + k].substring(i, j + 1);
        }
        return astring;
    }

    public boolean m_142505_() {
        NonNullList<Ingredient> nonnulllist = this.m_7527_();
        return nonnulllist.isEmpty() || nonnulllist.stream().filter(p_151277_ -> !p_151277_.m_43947_()).anyMatch(ForgeHooks::hasNoElements);
    }

    private static int firstNonSpace(String p_44185_) {
        int i;
        for (i = 0; i < p_44185_.length() && p_44185_.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int lastNonSpace(String p_44201_) {
        int i;
        for (i = p_44201_.length() - 1; i >= 0 && p_44201_.charAt(i) == ' '; --i) {
        }
        return i;
    }

    static String[] patternFromJson(JsonArray p_44197_) {
        String[] astring = new String[p_44197_.size()];
        if (astring.length > MAX_HEIGHT) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, " + MAX_HEIGHT + " is maximum");
        }
        if (astring.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < astring.length; ++i) {
            String s = GsonHelper.m_13805_((JsonElement)p_44197_.get(i), (String)("pattern[" + i + "]"));
            if (s.length() > MAX_WIDTH) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, " + MAX_WIDTH + " is maximum");
            }
            if (i > 0 && astring[0].length() != s.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            astring[i] = s;
        }
        return astring;
    }

    static Map<String, Ingredient> keyFromJson(JsonObject p_44211_) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : p_44211_.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put((String)entry.getKey(), ManaitaPlusNBTCraftingRecipe.fromJson((JsonElement)entry.getValue(), false));
        }
        map.put(" ", Ingredient.f_43901_);
        return map;
    }

    public static Ingredient fromJson(@javax.annotation.Nullable JsonElement p_289022_, boolean p_288974_) {
        if (p_289022_ != null && !p_289022_.isJsonNull()) {
            if (p_289022_.isJsonObject()) {
                return ManaitaPlusNBTCraftingRecipe.fromValues(Stream.of(ManaitaPlusNBTCraftingRecipe.valueFromJson(p_289022_.getAsJsonObject())));
            }
            if (p_289022_.isJsonArray()) {
                JsonArray jsonarray = p_289022_.getAsJsonArray();
                if (jsonarray.size() == 0 && !p_288974_) {
                    throw new JsonSyntaxException("Item array cannot be empty, at least one item must be defined");
                }
                return ManaitaPlusNBTCraftingRecipe.fromValues(StreamSupport.stream(jsonarray.spliterator(), false).map(p_289756_ -> ManaitaPlusNBTCraftingRecipe.valueFromJson(GsonHelper.m_13918_((JsonElement)p_289756_, (String)"item"))));
            }
            throw new JsonSyntaxException("Expected item to be object or array of objects");
        }
        throw new JsonSyntaxException("Item cannot be null");
    }

    public static Ingredient fromValues(Stream<? extends Ingredient.Value> p_43939_) {
        NBTIngredient ingredient = new NBTIngredient(p_43939_);
        return ingredient.m_43947_() ? Ingredient.f_43901_ : ingredient;
    }

    public static Ingredient.Value valueFromJson(JsonObject p_289797_) {
        if (p_289797_.has("item")) {
            Item item = ShapedRecipe.m_151278_((JsonObject)p_289797_);
            ItemStack p43953 = new ItemStack((ItemLike)item);
            if (p_289797_.has("type")) {
                int type = GsonHelper.m_13927_((JsonObject)p_289797_, (String)"type");
                p43953.m_41784_().m_128405_("ManaitaType", type);
            }
            return new Ingredient.ItemValue(p43953);
        }
        throw new JsonParseException("An ingredient entry needs  an item");
    }

    public static class NBTIngredient
    extends Ingredient {
        protected NBTIngredient(Stream<? extends Ingredient.Value> p_43907_) {
            super(p_43907_);
        }

        public boolean test(@Nullable ItemStack p_43914_) {
            if (p_43914_ == null) {
                return false;
            }
            if (this.m_43947_()) {
                return p_43914_.m_41619_();
            }
            for (ItemStack itemstack : this.m_43908_()) {
                int manaitaType;
                if (itemstack.m_41782_() && (manaitaType = itemstack.m_41783_().m_128451_("ManaitaType")) != 0 && (!p_43914_.m_41782_() || manaitaType != p_43914_.m_41783_().m_128451_("ManaitaType")) || !itemstack.m_150930_(p_43914_.m_41720_())) continue;
                return true;
            }
            return false;
        }
    }

    public static class Serializer
    implements RecipeSerializer<ManaitaPlusNBTCraftingRecipe> {
        private static final ResourceLocation NAME = new ResourceLocation("type_crafting_shaped");

        public ManaitaPlusNBTCraftingRecipe fromJson(ResourceLocation p_44236_, JsonObject p_44237_) {
            String s = GsonHelper.m_13851_((JsonObject)p_44237_, (String)"group", (String)"");
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)p_44237_, (String)"category", (String)null), (Enum)CraftingBookCategory.MISC);
            Map<String, Ingredient> map = ManaitaPlusNBTCraftingRecipe.keyFromJson(GsonHelper.m_13930_((JsonObject)p_44237_, (String)"key"));
            String[] astring = ManaitaPlusNBTCraftingRecipe.shrink(ManaitaPlusNBTCraftingRecipe.patternFromJson(GsonHelper.m_13933_((JsonObject)p_44237_, (String)"pattern")));
            int i = astring[0].length();
            int j = astring.length;
            NonNullList<Ingredient> nonnulllist = ManaitaPlusNBTCraftingRecipe.dissolvePattern(astring, map, i, j);
            ItemStack itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)p_44237_, (String)"result"));
            boolean flag = GsonHelper.m_13855_((JsonObject)p_44237_, (String)"show_notification", (boolean)true);
            return new ManaitaPlusNBTCraftingRecipe(p_44236_, s, craftingbookcategory, i, j, nonnulllist, itemstack, flag);
        }

        public ManaitaPlusNBTCraftingRecipe fromNetwork(ResourceLocation p_44239_, FriendlyByteBuf p_44240_) {
            int i = p_44240_.m_130242_();
            int j = p_44240_.m_130242_();
            String s = p_44240_.m_130277_();
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)p_44240_.m_130066_(CraftingBookCategory.class);
            NonNullList nonnulllist = NonNullList.m_122780_((int)(i * j), (Object)Ingredient.f_43901_);
            for (int k = 0; k < nonnulllist.size(); ++k) {
                nonnulllist.set(k, (Object)Ingredient.m_43940_((FriendlyByteBuf)p_44240_));
            }
            ItemStack itemstack = p_44240_.m_130267_();
            boolean flag = p_44240_.readBoolean();
            return new ManaitaPlusNBTCraftingRecipe(p_44239_, s, craftingbookcategory, i, j, (NonNullList<Ingredient>)nonnulllist, itemstack, flag);
        }

        public void toNetwork(FriendlyByteBuf p_44227_, ManaitaPlusNBTCraftingRecipe p_44228_) {
            p_44227_.m_130130_(p_44228_.width);
            p_44227_.m_130130_(p_44228_.height);
            p_44227_.m_130070_(p_44228_.group);
            p_44227_.m_130068_((Enum)p_44228_.category);
            for (Ingredient ingredient : p_44228_.recipeItems) {
                ingredient.m_43923_(p_44227_);
            }
            p_44227_.m_130055_(p_44228_.result);
            p_44227_.writeBoolean(p_44228_.showNotification);
        }
    }
}

