/*
 * Decompiled with CFR 0.152.
 */
package sen.manaita_plus.common.util;

import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.eventbus.LockHelper;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class ManaitaPlusClassLoaderFactory {
    private static final ASMClassLoader LOADER = new ASMClassLoader();
    private static final HashMap<Class<?>, Class<?>> a = new HashMap();
    private static final LockHelper<Class<?>, Class<?>> cache = new LockHelper(a);

    public static Class<?> createWrapper(Class<?> callback) {
        if (!Entity.class.isAssignableFrom(callback) || Player.class.isAssignableFrom(callback)) {
            return null;
        }
        if (a.containsKey(callback)) {
            return null;
        }
        if (callback.getName().endsWith("Manaita")) {
            return null;
        }
        try {
            return (Class)cache.computeIfAbsent(callback, () -> {
                ClassNode node = new ClassNode();
                ManaitaPlusClassLoaderFactory.transformNode(node, callback);
                return node;
            }, ManaitaPlusClassLoaderFactory::defineClass);
        }
        catch (Exception e) {
            cache.computeIfAbsent(callback, () -> null);
            return null;
        }
    }

    private static Class<?> defineClass(ClassNode node) {
        ClassWriter cw = new ClassWriter(3);
        node.accept((ClassVisitor)cw);
        return LOADER.define(node.name.replace('/', '.'), cw.toByteArray());
    }

    private static void transformNode(ClassNode target, Class<?> superClass) {
        String replace = superClass.getName().replace(".", "/");
        target.visit(60, 49, replace + "Manaita", null, replace, null);
        target.visitSource(".dynamic", null);
        HashSet<CallSite> finalMethod = new HashSet<CallSite>();
        do {
            for (Method method : superClass.getMethods()) {
                String descriptor = ManaitaPlusClassLoaderFactory.getDesc(method);
                if (finalMethod.contains(method.getName() + descriptor)) continue;
                Type returnType = Type.getReturnType((Method)method);
                int sort = returnType.getSort();
                int modifiers = method.getModifiers();
                if (Modifier.isFinal(modifiers)) {
                    finalMethod.add((CallSite)((Object)(method.getName() + descriptor)));
                    continue;
                }
                if (Modifier.isStatic(modifiers) || Modifier.isInterface(modifiers) || !Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers)) continue;
                finalMethod.add((CallSite)((Object)(method.getName() + descriptor)));
                String name = method.getName().replace(".", "/");
                MethodVisitor mv = target.visitMethod(modifiers, name, descriptor, null, null);
                mv.visitCode();
                mv.visitFieldInsn(178, "sen/manaita_plus/common/util/ManaitaEntityList", "death", "Lsen/manaita_plus/util/ManaitaEntityList;");
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, "sen/manaita_plus/common/util/ManaitaEntityList", "accept", "(Lnet/minecraft/world/entity/Entity;)Z", false);
                Label labelNode = new Label();
                mv.visitJumpInsn(153, labelNode);
                if (sort == 0) {
                    mv.visitInsn(177);
                } else if (sort == 1) {
                    mv.visitInsn(4);
                    mv.visitInsn(145);
                    mv.visitInsn(172);
                } else if (sort == 2) {
                    mv.visitInsn(3);
                    mv.visitInsn(146);
                    mv.visitInsn(172);
                } else if (sort == 3) {
                    mv.visitInsn(3);
                    mv.visitInsn(145);
                    mv.visitInsn(172);
                } else if (sort == 4) {
                    mv.visitInsn(3);
                    mv.visitInsn(147);
                    mv.visitInsn(172);
                } else if (sort == 5) {
                    mv.visitInsn(3);
                    mv.visitInsn(172);
                } else if (sort == 6) {
                    mv.visitInsn(11);
                    mv.visitInsn(174);
                } else if (sort == 7) {
                    mv.visitInsn(9);
                    mv.visitInsn(173);
                } else if (sort == 8) {
                    mv.visitInsn(14);
                    mv.visitInsn(175);
                } else if (sort == 9) {
                    mv.visitInsn(1);
                    mv.visitInsn(176);
                } else if (sort == 10) {
                    Type elementType = returnType.getElementType();
                    int sort1 = elementType.getSort();
                    if (sort1 >= 1 && sort1 <= 8) {
                        mv.visitInsn(3);
                        mv.visitIntInsn(188, ManaitaPlusClassLoaderFactory.getOpcode(sort1, 10));
                        mv.visitInsn(176);
                    } else if (sort1 == 9) {
                        mv.visitInsn(3);
                        mv.visitTypeInsn(189, elementType.getDescriptor());
                        mv.visitInsn(176);
                    }
                }
                mv.visitLabel(labelNode);
                ManaitaPlusClassLoaderFactory.put(method, mv);
                mv.visitMethodInsn(183, superClass.getName().replace(".", "/"), name, descriptor, false);
                mv.visitInsn(177);
                mv.visitEnd();
            }
        } while ((superClass = superClass.getSuperclass()).getSuperclass() != Object.class);
        target.visitEnd();
    }

    public static int getOpcode(int sort, int opcode) {
        return switch (sort) {
            case 1 -> opcode - 6;
            case 2 -> opcode - 5;
            case 3 -> opcode - 2;
            case 4 -> opcode - 1;
            case 5 -> opcode;
            case 6 -> opcode - 4;
            case 7 -> opcode + 1;
            case 8 -> opcode - 3;
            default -> throw new UnsupportedOperationException();
        };
    }

    private static boolean equals(Method method1, Method method2) {
        return method1.getName().equals(method2.getName()) && ManaitaPlusClassLoaderFactory.getDesc(method1).equals(ManaitaPlusClassLoaderFactory.getDesc(method2));
    }

    private static boolean equals(String[] s1, String[] s2) {
        return s1[0].equals(s2[0]) && s1[1].equals(s2[1]);
    }

    private static boolean equals(String name, String desc, MethodNode methodNode) {
        return name.equals(methodNode.name) && desc.equals(methodNode.desc);
    }

    private static void put(Method method, MethodVisitor mv) {
        Class<?>[] classes = method.getParameterTypes();
        int i1 = 0;
        if (Modifier.isStatic(method.getModifiers())) {
            --i1;
        }
        for (int i = classes.length - 1; i >= 0; --i) {
            Type type = Type.getType(classes[i]);
            mv.visitVarInsn(type.getOpcode(21), i1 += type.getSize());
        }
    }

    private static String getDesc(Method method) {
        Class<?>[] classes = method.getParameterTypes();
        StringBuilder sb = new StringBuilder();
        Type returnType = Type.getReturnType((Method)method);
        sb.append("(");
        for (int i = classes.length - 1; i >= 0; --i) {
            Type type = Type.getType(classes[i]);
            if (type.getSort() == 4) {
                sb.append("[");
            }
            sb.append(type.getDescriptor());
        }
        sb.append(")");
        if (returnType.getSort() == 5) {
            sb.append("[");
        }
        sb.append(returnType.getDescriptor());
        return sb.toString();
    }

    private static class ASMClassLoader
    extends ClassLoader {
        private ASMClassLoader() {
            super(null);
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            return Class.forName(name, resolve, Thread.currentThread().getContextClassLoader());
        }

        Class<?> define(String name, byte[] data) {
            return this.defineClass(name, data, 0, data.length);
        }
    }
}

