/*
 * Decompiled with CFR 0.152.
 */
package sen.manaita_plus.common.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.DragonFireball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.network.PacketDistributor;
import sen.manaita_plus.common.entity.ManaitaPlusLightningBolt;
import sen.manaita_plus.common.item.ManaitaPlusGodSwordItem;
import sen.manaita_plus.common.item.armor.ManaitaPlusArmor;
import sen.manaita_plus.common.item.data.IManaitaPlusDestroy;
import sen.manaita_plus.common.network.Networking;
import sen.manaita_plus.common.network.data.MessageDestroy;
import sen.manaita_plus.common.util.ManaitaPlusClassLoaderFactory;
import sen.manaita_plus.common.util.ManaitaPlusEntityList;
import sen.manaita_plus_core.util.Helper;

public class ManaitaPlusUtils {
    public static final Minecraft mc = Minecraft.m_91087_();

    public static Entity getEntity(Entity entity) {
        if (entity instanceof Arrow) {
            Arrow arrow = (Arrow)entity;
            return arrow.m_19749_();
        }
        if (entity instanceof DragonFireball) {
            DragonFireball fireball = (DragonFireball)entity;
            return fireball.m_19749_();
        }
        return entity;
    }

    public static void godKill(Player player, boolean remove) {
        ArrayList allEntities;
        Level level = player.m_9236_();
        boolean shiftKeyDown = player.m_6144_();
        if (shiftKeyDown && level.f_46443_ && Minecraft.m_91087_().m_18695_()) {
            mc.m_91106_().m_120405_();
            ManaitaPlusUtils.mc.f_91061_.m_107342_(ManaitaPlusUtils.mc.f_91073_);
        }
        if (level instanceof ClientLevel) {
            ClientLevel client = (ClientLevel)level;
            allEntities = Lists.newArrayList((Iterable)client.m_104735_());
        } else if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            allEntities = Lists.newArrayList((Iterable)server.m_8583_());
        } else {
            return;
        }
        ArrayList<Entity> tntities = new ArrayList<Entity>();
        for (Entity entity : allEntities) {
            Entity target = ManaitaPlusUtils.getEntity(entity);
            if (target == null || target instanceof Player || target instanceof ManaitaPlusLightningBolt) continue;
            if (target instanceof ItemEntity || target instanceof ExperienceOrb) {
                tntities.add(target);
                continue;
            }
            if (!shiftKeyDown && !(target instanceof Monster)) continue;
            ManaitaPlusUtils.kill(target, shiftKeyDown, remove);
        }
        if (!level.f_46443_) {
            for (Entity tntity : tntities) {
                if (tntity instanceof ItemEntity) {
                    ItemEntity item = (ItemEntity)tntity;
                    item.m_32061_();
                    item.m_6123_(player);
                    continue;
                }
                if (!(tntity instanceof ExperienceOrb)) continue;
                ExperienceOrb xp = (ExperienceOrb)tntity;
                player.f_36101_ = 0;
                xp.m_6123_(player);
            }
        }
    }

    public static void kill(Entity target, boolean isSnk, boolean remove) {
        Class<?> wrapper;
        if (!target.m_9236_().f_46443_) {
            if (!ManaitaPlusEntityList.attack.accept(target)) {
                ManaitaPlusEntityList.attack.add(target);
                if (target instanceof LivingEntity) {
                    living = (LivingEntity)target;
                    DamageSource damageSource = target.m_269291_().m_269341_();
                    living.m_6469_(damageSource, Float.MAX_VALUE);
                    living.m_21153_(0.0f);
                    living.m_6667_(damageSource);
                }
            } else {
                ManaitaPlusEntityList.attack.remove(target);
                if (target instanceof LivingEntity) {
                    living = (LivingEntity)target;
                    living.f_20917_ += 10;
                    living.f_20916_ += 10;
                    living.f_20919_ += 10;
                }
            }
        }
        ManaitaPlusEntityList.death.add(target);
        if (remove) {
            if (!target.m_9236_().f_46443_) {
                target.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            ManaitaPlusEntityList.remove.add(target);
        }
        if (isSnk && (wrapper = ManaitaPlusClassLoaderFactory.createWrapper(target.getClass())) != null) {
            Helper.setFieldValue(target, wrapper);
        }
    }

    public static boolean hasItem(Entity entity, ItemStack stack) {
        Player player;
        if (entity instanceof Player && (player = (Player)entity).m_150109_() != null) {
            return player.m_150109_().m_36063_(stack);
        }
        return false;
    }

    public static boolean hasItem(Entity entity, Item item) {
        Player player;
        if (entity instanceof Player && (player = (Player)entity).m_150109_() != null) {
            return player.m_150109_().m_216874_(stack -> !stack.m_41619_() && stack.m_41720_().getClass() == item.getClass());
        }
        return false;
    }

    public static boolean isManaita(Player player) {
        if (player.m_150109_() != null) {
            return player.m_150109_().m_216874_(stack -> !stack.m_41619_() && stack.m_41720_() instanceof ManaitaPlusGodSwordItem);
        }
        return false;
    }

    public static void dropResources(BlockState p_49882_, Level p_49883_, BlockPos p_49884_, @Nullable BlockEntity p_49885_, @Nullable Entity p_49886_, ItemStack p_49887_, boolean dropXp) {
        if (p_49883_ instanceof ServerLevel) {
            List<ItemStack> drops = ManaitaPlusUtils.getDrops(p_49882_, (ServerLevel)p_49883_, p_49884_, p_49885_, p_49886_, p_49887_);
            if (drops.isEmpty()) {
                drops.add(new ItemStack((ItemLike)p_49882_.m_60734_()));
            }
            drops.forEach(p_49944_ -> ManaitaPlusUtils.popResource(p_49883_, p_49884_, p_49944_));
            p_49882_.m_222967_((ServerLevel)p_49883_, p_49884_, p_49887_, dropXp);
        }
    }

    public static void popResource(Level p_49841_, BlockPos p_49842_, ItemStack p_49843_) {
        double d0 = (double)EntityType.f_20461_.m_20679_() / 2.0;
        double d1 = (double)p_49842_.m_123341_() + 0.5 + Mth.m_216263_((RandomSource)p_49841_.f_46441_, (double)-0.25, (double)0.25);
        double d2 = (double)p_49842_.m_123342_() + 0.5 + Mth.m_216263_((RandomSource)p_49841_.f_46441_, (double)-0.25, (double)0.25) - d0;
        double d3 = (double)p_49842_.m_123343_() + 0.5 + Mth.m_216263_((RandomSource)p_49841_.f_46441_, (double)-0.25, (double)0.25);
        ManaitaPlusUtils.popResource(p_49841_, () -> new ItemEntity(p_49841_, d1, d2, d3, p_49843_), p_49843_);
    }

    public static List<ItemStack> getDrops(BlockState p_49875_, ServerLevel p_49876_, BlockPos p_49877_, @Nullable BlockEntity p_49878_, @Nullable Entity p_49879_, ItemStack p_49880_) {
        LootParams.Builder lootparams$builder = new LootParams.Builder(p_49876_).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)p_49877_)).m_287286_(LootContextParams.f_81463_, (Object)p_49880_).m_287289_(LootContextParams.f_81455_, (Object)p_49879_).m_287289_(LootContextParams.f_81462_, (Object)p_49878_);
        return p_49875_.m_287290_(lootparams$builder);
    }

    private static void popResource(Level p_152441_, Supplier<ItemEntity> p_152442_, ItemStack p_152443_) {
        if (!p_152441_.f_46443_ && !p_152443_.m_41619_()) {
            ItemEntity itementity = p_152442_.get();
            itementity.m_32060_();
            p_152441_.m_7967_((Entity)itementity);
        }
    }

    public static void popExperience(ServerLevel p_49806_, BlockPos p_49807_, int p_49808_) {
        if (p_49806_.m_46469_().m_46207_(GameRules.f_46136_) && !p_49806_.restoringBlockSnapshots) {
            ExperienceOrb.m_147082_((ServerLevel)p_49806_, (Vec3)Vec3.m_82512_((Vec3i)p_49807_), (int)p_49808_);
        }
    }

    public static boolean isManaitaArmor(Player player) {
        for (ItemStack itemStack : player.m_150109_().f_35975_) {
            if (itemStack != null && itemStack.m_41720_() instanceof ManaitaPlusArmor) continue;
            return false;
        }
        return true;
    }

    public static boolean isManaitaArmorPart(Player player) {
        for (ItemStack itemStack : player.m_150109_().f_35975_) {
            if (itemStack == null || !(itemStack.m_41720_() instanceof ManaitaPlusArmor)) continue;
            return true;
        }
        return false;
    }

    public static void desBlocks(ItemStack stack, Level level, BlockPos blockPos, Player player) {
        Item item = stack.m_41720_();
        if (item instanceof IManaitaPlusDestroy) {
            IManaitaPlusDestroy des = (IManaitaPlusDestroy)item;
            int range = des.getRange(stack) >> 1;
            ManaitaPlusUtils.desBlock(stack, level, blockPos, player);
            if (range == 0) {
                return;
            }
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8795_(p -> {
                    Networking.INSTANCE.send(PacketDistributor.PLAYER.with(() -> p), (Object)new MessageDestroy(blockPos, range, stack.m_41720_()));
                    return false;
                });
                int xM = blockPos.m_123341_() + range;
                int yM = blockPos.m_123342_() + range;
                int zM = blockPos.m_123343_() + range;
                BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
                for (int x = blockPos.m_123341_() - range; x <= xM; ++x) {
                    for (int y = blockPos.m_123342_() - range; y <= yM; ++y) {
                        for (int z = blockPos.m_123343_() - range; z <= zM; ++z) {
                            BlockState blockState = level.m_8055_((BlockPos)mutableBlockPos.m_122178_(x, y, z));
                            if (blockState == null || !des.accept(blockState)) continue;
                            Block block = blockState.m_60734_();
                            BlockEntity blockEntity = serverLevel.m_7702_((BlockPos)mutableBlockPos);
                            boolean removed = ManaitaPlusUtils.setBlock(level, (BlockPos)mutableBlockPos, level.m_6425_((BlockPos)mutableBlockPos).m_76188_());
                            if (removed) {
                                block.m_6786_((LevelAccessor)level, (BlockPos)mutableBlockPos, blockState);
                            }
                            player.m_36246_(Stats.f_12949_.m_12902_((Object)block));
                            player.m_36399_(0.005f);
                            player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                            List drops = Block.m_49874_((BlockState)blockState, (ServerLevel)serverLevel, (BlockPos)mutableBlockPos, (BlockEntity)blockEntity, (Entity)player, (ItemStack)stack);
                            if (drops.isEmpty()) {
                                ManaitaPlusUtils.popResource((Level)serverLevel, (BlockPos)mutableBlockPos, new ItemStack((ItemLike)block));
                            } else {
                                drops.forEach(p_49859_ -> ManaitaPlusUtils.popResource((Level)serverLevel, (BlockPos)mutableBlockPos, p_49859_));
                            }
                            int exp = blockState.getExpDrop((LevelReader)serverLevel, serverLevel.f_46441_, (BlockPos)mutableBlockPos, stack.getEnchantmentLevel(Enchantments.f_44987_), stack.getEnchantmentLevel(Enchantments.f_44985_));
                            block.m_49805_(serverLevel, (BlockPos)mutableBlockPos, exp);
                        }
                    }
                }
            }
        }
    }

    public static boolean setBlock(Level level, BlockPos p_46605_, BlockState p_46606_) {
        BlockState blockstate;
        int p_46607_;
        int n = p_46607_ = level.f_46443_ ? 8 : 1;
        if (level.m_151570_(p_46605_)) {
            return false;
        }
        if (!level.f_46443_ && level.m_46659_()) {
            return false;
        }
        LevelChunk levelchunk = level.m_46745_(p_46605_);
        p_46605_ = p_46605_.m_7949_();
        BlockSnapshot blockSnapshot = null;
        if (level.captureBlockSnapshots && !level.f_46443_) {
            blockSnapshot = BlockSnapshot.create((ResourceKey)level.m_46472_(), (LevelAccessor)level, (BlockPos)p_46605_, (int)p_46607_);
            level.capturedBlockSnapshots.add(blockSnapshot);
        }
        if ((blockstate = levelchunk.m_6978_(p_46605_, p_46606_, false)) == null) {
            if (blockSnapshot != null) {
                level.capturedBlockSnapshots.remove(blockSnapshot);
            }
            return false;
        }
        if (blockSnapshot == null) {
            level.markAndNotifyBlock(p_46605_, levelchunk, blockstate, p_46606_, p_46607_, 512);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void desBlock(ItemStack stack, Level level, BlockPos pos, Player player) {
        Item item = stack.m_41720_();
        if (!(item instanceof IManaitaPlusDestroy)) return;
        IManaitaPlusDestroy des = (IManaitaPlusDestroy)item;
        BlockState blockState = level.m_8055_(pos);
        if (blockState == null) return;
        if (!des.accept(blockState)) {
            return;
        }
        Block block = blockState.m_60734_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (player instanceof ServerPlayer) {
                boolean removed;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                BlockEntity blockEntity = serverLevel.m_7702_(pos);
                if (serverLevel.m_7702_(pos) == null) {
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundBlockUpdatePacket(pos, serverLevel.m_6425_(pos).m_76188_()));
                }
                if (removed = blockState.onDestroyedByPlayer(level, pos, player, false, level.m_6425_(pos))) {
                    block.m_6786_((LevelAccessor)level, pos, blockState);
                }
                player.m_36246_(Stats.f_12949_.m_12902_((Object)block));
                player.m_36399_(0.005f);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                List<ItemStack> drops = Block.m_49874_((BlockState)blockState, (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)player, (ItemStack)stack);
                if (drops.isEmpty()) {
                    drops = List.of(new ItemStack((ItemLike)block));
                }
                drops.forEach(p_49859_ -> ManaitaPlusUtils.popResource((Level)serverLevel, pos, p_49859_));
                int exp = blockState.getExpDrop((LevelReader)serverLevel, serverLevel.f_46441_, pos, stack.getEnchantmentLevel(Enchantments.f_44987_), stack.getEnchantmentLevel(Enchantments.f_44985_));
                block.m_49805_(serverLevel, pos, exp);
                return;
            }
        }
        if (!(level instanceof ClientLevel)) return;
        ClientLevel clientLevel = (ClientLevel)level;
        SoundType soundtype = blockState.getSoundType((LevelReader)clientLevel, pos, (Entity)player);
        mc.m_91106_().m_120367_((SoundInstance)new SimpleSoundInstance(soundtype.m_56778_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 8.0f, soundtype.m_56774_() * 0.5f, SoundInstance.m_235150_(), pos));
    }

    public static String getTypes(int i) {
        if (i == 1) {
            return "wooden.";
        }
        if (i == 2) {
            return "stone.";
        }
        if (i == 3) {
            return "iron.";
        }
        if (i == 4) {
            return "gold.";
        }
        if (i == 5) {
            return "diamond.";
        }
        if (i == 6) {
            return "emerald.";
        }
        if (i == 7) {
            return "redstone.";
        }
        if (i == 8) {
            return "netherite.";
        }
        return "";
    }

    public static String getTypes1(int i) {
        if (i == 2) {
            return "stone";
        }
        if (i == 3) {
            return "iron";
        }
        if (i == 4) {
            return "gold";
        }
        if (i == 5) {
            return "diamond";
        }
        if (i == 6) {
            return "emerald";
        }
        if (i == 7) {
            return "redstone";
        }
        if (i == 8) {
            return "netherite";
        }
        return "wooden";
    }

    public static void chat(Component p_93786_) {
        Minecraft.m_91087_().f_91065_.m_93076_().m_93785_(p_93786_);
    }
}

