/*
 * Decompiled with CFR 0.152.
 */
package sen.manaita_plus_core.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityLookup;
import net.minecraft.world.level.entity.EntityTickList;
import sen.manaita_plus.common.item.ManaitaPlusGodSwordItem;
import sen.manaita_plus.common.util.ManaitaPlusEntityList;
import sen.manaita_plus.common.util.ManaitaPlusUtils;

public class EventUtil {
    public static float getHealth(Player player) {
        if (ManaitaPlusUtils.isManaita(player) || ManaitaPlusEntityList.player.accept((Entity)player)) {
            player.m_21153_(20.0f);
            return player.m_21233_();
        }
        if (ManaitaPlusEntityList.death.accept((Entity)player)) {
            return 0.0f;
        }
        return ((Float)player.m_20088_().m_135370_(LivingEntity.f_20961_)).floatValue();
    }

    public static float getHealth(LivingEntity entity) {
        Player player;
        if (entity instanceof Player && (ManaitaPlusUtils.isManaita(player = (Player)entity) || ManaitaPlusEntityList.player.accept((Entity)player))) {
            player.m_21153_(20.0f);
            return player.m_21233_();
        }
        if (ManaitaPlusEntityList.death.accept((Entity)entity)) {
            return 0.0f;
        }
        return ((Float)entity.m_20088_().m_135370_(LivingEntity.f_20961_)).floatValue();
    }

    public static EntityTickList getTickingEntities(ClientLevel level) {
        ObjectIterator iterator = level.f_171630_.f_156903_.int2ObjectEntrySet().iterator();
        while (iterator.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iterator.next();
            if (!ManaitaPlusEntityList.remove.accept((Entity)entry.getValue())) continue;
            iterator.remove();
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (ManaitaPlusEntityList.player.accept((Entity)player) && !level.f_171630_.m_156914_((Entity)player)) {
            level.f_171630_.m_156908_((Entity)player);
        }
        return level.f_171630_;
    }

    public static EntityTickList getEntityTickList(ServerLevel level) {
        ObjectIterator iterator = level.f_143243_.f_156903_.int2ObjectEntrySet().iterator();
        while (iterator.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iterator.next();
            if (!ManaitaPlusEntityList.remove.accept((Entity)entry.getValue())) continue;
            iterator.remove();
        }
        for (ServerPlayer player : level.m_6907_()) {
            if (!ManaitaPlusEntityList.player.accept((Entity)player) || level.f_143243_.m_156914_((Entity)player)) continue;
            level.f_143243_.m_156908_((Entity)player);
        }
        return level.f_143243_;
    }

    public static <T extends EntityAccess> Int2ObjectMap<T> getById(EntityLookup<T> lookup) {
        ObjectIterator iterator = lookup.f_156807_.int2ObjectEntrySet().iterator();
        while (iterator.hasNext()) {
            Entity entity;
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iterator.next();
            Object object = entry.getValue();
            if (!(object instanceof Entity) || !ManaitaPlusEntityList.remove.accept(entity = (Entity)object)) continue;
            iterator.remove();
        }
        return lookup.f_156807_;
    }

    public static double getAttributeValue(LivingEntity living, Attribute p_21134_) {
        double value = living.m_21204_().m_22181_(p_21134_);
        if (p_21134_ == Attributes.f_22276_ && value < 20.0) {
            living.m_21051_(Attributes.f_22276_).m_22100_(20.0);
            return 20.0;
        }
        if (p_21134_ == Attributes.f_22279_ && value < 0.1) {
            living.m_21051_(Attributes.f_22279_).m_22100_(0.15);
            return 0.15;
        }
        if (p_21134_ == Attributes.f_22280_ && value < 0.05) {
            living.m_21051_(Attributes.f_22280_).m_22100_(0.075);
            return 0.15;
        }
        return value;
    }

    public static boolean isManaita(LocalPlayer localPlayer) {
        return localPlayer.m_150109_().m_216874_(stack -> !stack.m_41619_() && stack.m_41720_() instanceof ManaitaPlusGodSwordItem) || ManaitaPlusEntityList.player.accept((Entity)localPlayer);
    }

    public static boolean isManaita(LivingEntity living) {
        Player player;
        return living instanceof Player && (ManaitaPlusUtils.isManaita(player = (Player)living) || ManaitaPlusEntityList.player.accept((Entity)player));
    }

    public static boolean isManaita(Entity entity) {
        Player player;
        return entity instanceof Player && (ManaitaPlusUtils.isManaita(player = (Player)entity) || ManaitaPlusEntityList.player.accept((Entity)player));
    }

    public static boolean isDead(LivingEntity living) {
        return ManaitaPlusEntityList.death.accept((Entity)living);
    }

    public static boolean isDead(LocalPlayer localPlayer) {
        return ManaitaPlusEntityList.death.accept((Entity)localPlayer);
    }

    public static boolean isDead(Entity entity) {
        return ManaitaPlusEntityList.death.accept(entity);
    }

    public static boolean isRemove(LivingEntity localPlayer) {
        return ManaitaPlusEntityList.remove.accept((Entity)localPlayer);
    }

    public static boolean isRemove(Entity entity) {
        return ManaitaPlusEntityList.remove.accept(entity);
    }

    public static float getMaxHealth(LivingEntity living) {
        float attributeValue = (float)living.m_21133_(Attributes.f_22276_);
        if (attributeValue > 20.0f) {
            living.m_21051_(Attributes.f_22276_).m_22100_(20.0);
            return 20.0f;
        }
        return attributeValue;
    }

    public static void onFind(Map map) {
        ArrayList list = new ArrayList();
        ArrayList list2 = new ArrayList();
        list.addAll(map.values());
        for (Object value : list) {
            if (!(value instanceof List)) continue;
            List list1 = (List)value;
            list2.clear();
            for (Object o : list1) {
                Entity entity;
                if (!(o instanceof Entity) || !ManaitaPlusEntityList.remove.accept(entity = (Entity)o)) continue;
                list2.add(o);
            }
            list1.removeAll(list2);
        }
    }

    public static void onIterator(List<Object> list1) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object o : list1.toArray()) {
            Entity entity;
            if (!(o instanceof Entity) || !ManaitaPlusEntityList.remove.accept(entity = (Entity)o)) continue;
            list.add(o);
        }
        list1.removeAll(list);
    }
}

