/*
 * Decompiled with CFR 0.152.
 */
package sen.manaita_plus_core.util;

import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.ModuleLayerHandler;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fml.loading.ModDirTransformerDiscoverer;
import sun.misc.Unsafe;

public class Helper {
    private static final Unsafe UNSAFE = Helper.getUnsafe();
    private static final MethodHandles.Lookup lookup = Helper.getFieldValue(MethodHandles.Lookup.class, "IMPL_LOOKUP", MethodHandles.Lookup.class);
    private static final Object internalUNSAFE = Helper.getInternalUNSAFE();
    private static MethodHandle objectFieldOffsetInternal;

    private static Unsafe getUnsafe() {
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            return (Unsafe)theUnsafe.get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Object getInternalUNSAFE() {
        try {
            Class<?> clazz = lookup.findClass("jdk.internal.misc.Unsafe");
            return lookup.findStatic(clazz, "getUnsafe", MethodType.methodType(clazz)).invoke();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T getFieldValue(Field f, Object target, Class<T> clazz) {
        try {
            long offset;
            if (Modifier.isStatic(f.getModifiers())) {
                target = UNSAFE.staticFieldBase(f);
                offset = UNSAFE.staticFieldOffset(f);
            } else {
                offset = Helper.objectFieldOffset(f);
            }
            return (T)UNSAFE.getObject(target, offset);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static long objectFieldOffset(Field f) {
        try {
            return UNSAFE.objectFieldOffset(f);
        }
        catch (Throwable e) {
            try {
                return objectFieldOffsetInternal.invoke(f);
            }
            catch (Throwable t1) {
                t1.printStackTrace();
                return 0L;
            }
        }
    }

    public static <T> T getFieldValue(Object target, String fieldName, Class<T> clazz) {
        try {
            return Helper.getFieldValue(target.getClass().getDeclaredField(fieldName), target, clazz);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T getFieldValue(Class<?> target, String fieldName, Class<T> clazz) {
        try {
            return Helper.getFieldValue(target.getDeclaredField(fieldName), null, clazz);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setFieldValue(Object target, Class<?> value) {
        try {
            int aVolatile = UNSAFE.getIntVolatile(UNSAFE.allocateInstance(value), 8L);
            UNSAFE.putIntVolatile(target, 8L, aVolatile);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void setFieldValue(Object target, String fieldName, Object value) {
        try {
            Helper.setFieldValue(target.getClass().getDeclaredField(fieldName), target, value);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void setFieldValue(Field f, Object target, Object value) {
        try {
            long offset;
            if (Modifier.isStatic(f.getModifiers())) {
                target = UNSAFE.staticFieldBase(f);
                offset = UNSAFE.staticFieldOffset(f);
            } else {
                offset = Helper.objectFieldOffset(f);
            }
            UNSAFE.putObject(target, offset, value);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static String getJarPath(Class<?> clazz) {
        String file = clazz.getProtectionDomain().getCodeSource().getLocation().getPath();
        if (!file.isEmpty()) {
            if (file.startsWith("union:")) {
                file = file.substring(6);
            }
            if (file.startsWith("/")) {
                file = file.substring(1);
            }
            file = file.substring(0, file.lastIndexOf(".jar") + 4);
            file = file.replaceAll("/", "\\\\");
        }
        return URLDecoder.decode(file, StandardCharsets.UTF_8);
    }

    public static void coexistenceCoreAndMod() {
        List found = Helper.getFieldValue(ModDirTransformerDiscoverer.class, "found", List.class);
        found.removeIf(namedPath -> Helper.getJarPath(Helper.class).equals(namedPath.paths()[0].toString()));
        Helper.getFieldValue(Helper.getFieldValue(Launcher.INSTANCE, "moduleLayerHandler", ModuleLayerHandler.class), "completedLayers", EnumMap.class).values().forEach(layerInfo -> {
            ModuleLayer layer = Helper.getFieldValue(layerInfo, "layer", ModuleLayer.class);
            layer.modules().forEach(module -> {
                if (module.getName().equals(Helper.class.getModule().getName())) {
                    HashSet modules = new HashSet(Helper.getFieldValue(layer.configuration(), "modules", Set.class));
                    HashMap nameToModule = new HashMap(Helper.getFieldValue(layer.configuration(), "nameToModule", Map.class));
                    modules.remove(nameToModule.remove(Helper.class.getModule().getName()));
                    Helper.setFieldValue(layer.configuration(), "modules", modules);
                    Helper.setFieldValue(layer.configuration(), "nameToModule", nameToModule);
                }
            });
        });
    }

    public static boolean checkClass(Object o) {
        return o.getClass().getName().startsWith("net.minecraft.");
    }

    public static void copyProperties(Class<?> clazz, Object source, Object target) {
        try {
            AccessibleObject[] fields = clazz.getDeclaredFields();
            AccessibleObject.setAccessible(fields, true);
            for (AccessibleObject field : fields) {
                if (Modifier.isStatic(((Field)field).getModifiers())) continue;
                ((Field)field).set(target, ((Field)field).get(source));
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            Class<?> internalUNSAFEClass = lookup.findClass("jdk.internal.misc.Unsafe");
            objectFieldOffsetInternal = lookup.findVirtual(internalUNSAFEClass, "objectFieldOffset", MethodType.methodType(Long.TYPE, Field.class)).bindTo(internalUNSAFE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

