/*
 * Decompiled with CFR 0.152.
 */
package ph.discorde.good_night_sweetie.client;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_310;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class Good_night_sweetieClient
implements ClientModInitializer {
    private boolean wasSleeping = false;
    private EyeState currentState = EyeState.OPEN;
    private float animationProgress = 0.0f;
    private static final int BLINK_DURATION = 4;
    private static final int CLOSING_DURATION = 25;
    private static final int OPENING_DURATION = 35;
    private static final int PAUSE_BETWEEN_BLINKS = 6;

    public void onInitializeClient() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1724 == null) {
                return;
            }
            boolean isSleeping = client.field_1724.method_6113();
            if (isSleeping && !this.wasSleeping) {
                this.wasSleeping = true;
                this.currentState = EyeState.BLINKING_1;
                this.animationProgress = 0.0f;
            } else if (!isSleeping && this.wasSleeping) {
                this.wasSleeping = false;
                this.currentState = EyeState.OPENING;
                this.animationProgress = 0.0f;
            }
            this.updateAnimation();
        });
        HudRenderCallback.EVENT.register((guiGraphics, tickDelta) -> {
            if (this.currentState != EyeState.OPEN) {
                float partialTick = tickDelta.method_60636();
                this.renderEyes(guiGraphics, partialTick);
            }
        });
    }

    private void updateAnimation() {
        float increment = 1.0f;
        switch (this.currentState.ordinal()) {
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                this.animationProgress += increment;
                if (!(this.animationProgress > 14.0f)) break;
                this.animationProgress = 0.0f;
                this.currentState = this.getNextState(this.currentState);
                break;
            }
            case 3: {
                this.animationProgress += increment;
                if (!(this.animationProgress > 25.0f)) break;
                this.currentState = EyeState.CLOSED;
                this.animationProgress = 0.0f;
                break;
            }
            case 5: {
                this.animationProgress += increment;
                if (!(this.animationProgress > 35.0f)) break;
                this.currentState = EyeState.WAKING_BLINK_1;
                this.animationProgress = 0.0f;
            }
        }
    }

    private EyeState getNextState(EyeState current) {
        return switch (current.ordinal()) {
            case 1 -> EyeState.BLINKING_2;
            case 2 -> EyeState.CLOSING;
            case 6 -> EyeState.WAKING_BLINK_2;
            case 7 -> EyeState.OPEN;
            default -> current;
        };
    }

    private void renderEyes(class_332 guiGraphics, float partialTick) {
        class_310 client = class_310.method_1551();
        int width = client.method_22683().method_4486();
        int height = client.method_22683().method_4502();
        float progress = this.animationProgress + partialTick;
        float closedAmount = this.calculateEyeClosedAmount(progress);
        if (closedAmount > 0.01f) {
            int eyeHeight = (int)((float)height * closedAmount / 2.0f);
            guiGraphics.method_25294(0, 0, width, eyeHeight, -16777216);
            guiGraphics.method_25294(0, height - eyeHeight, width, height, -16777216);
        }
    }

    private float calculateEyeClosedAmount(float progress) {
        return switch (this.currentState.ordinal()) {
            case 4 -> 1.0f;
            case 1, 2, 6, 7 -> {
                if (progress < 4.0f) {
                    yield this.easeInOutCubic(progress / 4.0f);
                }
                if (progress < 8.0f) {
                    yield this.easeInOutCubic(1.0f - (progress - 4.0f) / 4.0f);
                }
                yield 0.0f;
            }
            case 3 -> this.easeInCubic(Math.min(1.0f, progress / 25.0f));
            case 5 -> this.easeOutCubic(Math.max(0.0f, 1.0f - progress / 35.0f));
            default -> 0.0f;
        };
    }

    private float easeInOutCubic(float t) {
        return t < 0.5f ? 4.0f * t * t * t : 1.0f - (float)Math.pow(-2.0f * t + 2.0f, 3.0) / 2.0f;
    }

    private float easeInCubic(float t) {
        return t * t * t;
    }

    private float easeOutCubic(float t) {
        return 1.0f - (float)Math.pow(1.0f - t, 3.0);
    }

    @Environment(value=EnvType.CLIENT)
    private static enum EyeState {
        OPEN,
        BLINKING_1,
        BLINKING_2,
        CLOSING,
        CLOSED,
        OPENING,
        WAKING_BLINK_1,
        WAKING_BLINK_2;

    }
}

