/*
 * Decompiled with CFR 0.152.
 */
package us.timinc.mc.cobblemon.timcore.mixin.helper;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import us.timinc.mc.cobblemon.timcore.PokemonExtensionsKt;
import us.timinc.mc.cobblemon.timcore.ReservationType;
import us.timinc.mc.cobblemon.timcore.TimCore;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lus/timinc/mc/cobblemon/timcore/mixin/helper/CantHurtPokemonEntityHelper;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "pokemonEntity", "Lnet/minecraft/world/damagesource/DamageSource;", "damageSource", "", "cantBeHurtBecauseOwned", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/damagesource/DamageSource;)Z", "cantBeHurtInGeneral", "(Lnet/minecraft/world/damagesource/DamageSource;)Z", "common"})
public final class CantHurtPokemonEntityHelper {
    @NotNull
    public static final CantHurtPokemonEntityHelper INSTANCE = new CantHurtPokemonEntityHelper();

    private CantHurtPokemonEntityHelper() {
    }

    public final boolean cantBeHurtInGeneral(@NotNull DamageSource damageSource) {
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        return ((TimCore.Config)TimCore.INSTANCE.getConfig()).getPokemonEntitiesAreInvulnerable() && !damageSource.isCreativePlayer() && !damageSource.is(DamageTypes.GENERIC_KILL);
    }

    public final boolean cantBeHurtBecauseOwned(@NotNull PokemonEntity pokemonEntity, @NotNull DamageSource damageSource) {
        Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"pokemonEntity");
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        if (!((TimCore.Config)TimCore.INSTANCE.getConfig()).getReservedPokemonEntitiesAreInvulnerable()) {
            return false;
        }
        Entity entity = damageSource.getEntity();
        ServerPlayer serverPlayer = entity instanceof ServerPlayer ? (ServerPlayer)entity : null;
        if (serverPlayer == null) {
            return false;
        }
        ServerPlayer player = serverPlayer;
        Pokemon pokemon = pokemonEntity.getPokemon();
        if (PokemonExtensionsKt.isReservedFor(pokemon, player) == ReservationType.RESERVED_FOR_OTHER) {
            player.sendSystemMessage((Component)TimCore.TranslationComponents.INSTANCE.reserved(pokemon));
            return true;
        }
        return false;
    }
}

