/*
 * Decompiled with CFR 0.152.
 */
package us.timinc.mc.cobblemon.timcore.handler;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.events.battles.BattleVictoryEvent;
import com.cobblemon.mod.common.api.tags.CobblemonItemTags;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import us.timinc.mc.cobblemon.timcore.AbstractHandler;
import us.timinc.mc.cobblemon.timcore.Debugger;
import us.timinc.mc.cobblemon.timcore.PlayerExtensionsKt;
import us.timinc.mc.cobblemon.timcore.PokemonExtensionsKt;
import us.timinc.mc.cobblemon.timcore.TimCore;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lus/timinc/mc/cobblemon/timcore/handler/ExpAllHandler;", "Lus/timinc/mc/cobblemon/timcore/AbstractHandler;", "Lcom/cobblemon/mod/common/api/events/battles/BattleVictoryEvent;", "<init>", "()V", "evt", "", "handle", "(Lcom/cobblemon/mod/common/api/events/battles/BattleVictoryEvent;)V", "common"})
public final class ExpAllHandler
extends AbstractHandler<BattleVictoryEvent> {
    @NotNull
    public static final ExpAllHandler INSTANCE = new ExpAllHandler();

    private ExpAllHandler() {
    }

    @Override
    public void handle(@NotNull BattleVictoryEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        if (!((TimCore.Config)TimCore.INSTANCE.getConfig()).getEnableExpAll()) {
            return;
        }
        Debugger.Case caseDebugger = Debugger.getCaseDebugger$default(TimCore.INSTANCE.getDebugger(), null, 1, null);
        Debugger.debug$default(caseDebugger, "Reviewing post-battle for ExpAll logic.", false, 2, null);
        for (BattleActor winner : evt.getWinners()) {
            for (BattlePokemon winningPokemon : winner.getPokemonList()) {
                String winningPokemonIdentifier = PokemonExtensionsKt.getIdentifier(winningPokemon.getEffectedPokemon());
                Debugger.debug$default(caseDebugger, "Reviewing winner " + winningPokemonIdentifier + "...", false, 2, null);
                class_3222 owner = winningPokemon.getOriginalPokemon().getOwnerPlayer();
                if (owner == null) {
                    Debugger.debug$default(caseDebugger, "Not player-owned, skipping.", false, 2, null);
                    continue;
                }
                if (!PlayerExtensionsKt.hasExpAllFor(owner, winningPokemon.getEffectedPokemon())) {
                    Debugger.debug$default(caseDebugger, "Player " + owner.method_5477() + " does not have an ExpAll, skipping.", false, 2, null);
                    continue;
                }
                for (BattleActor loser : evt.getLosers()) {
                    for (BattlePokemon losingPokemon : loser.getPokemonList()) {
                        String losingPokemonIdentifier = PokemonExtensionsKt.getIdentifier(losingPokemon.getEffectedPokemon());
                        Debugger.debug$default(caseDebugger, "Reviewing loser " + losingPokemonIdentifier + "...", false, 2, null);
                        if (winningPokemon.getFacedOpponents().contains(losingPokemon)) {
                            Debugger.debug$default(caseDebugger, "Faced " + losingPokemonIdentifier + ", skipping as exp already given by Cobblemon.", false, 2, null);
                            continue;
                        }
                        if (winningPokemon.getEffectedPokemon().heldItem().method_31573(CobblemonItemTags.EXPERIENCE_SHARE)) {
                            Debugger.debug$default(caseDebugger, "Holding ExpShare, skipping as exp already given by Cobblemon.", false, 2, null);
                            continue;
                        }
                        int experience = Cobblemon.INSTANCE.getExperienceCalculator().calculate(winningPokemon, losingPokemon, (double)((TimCore.Config)TimCore.INSTANCE.getConfig()).getExpAllMultiplier());
                        if (experience <= 0) {
                            Debugger.debug$default(caseDebugger, "Calculated experience less than or equal to 0, skipping.", false, 2, null);
                            continue;
                        }
                        Debugger.debug$default(caseDebugger, "Awarding " + experience + " experience.", false, 2, null);
                        winningPokemon.getActor().awardExperience(winningPokemon, experience);
                    }
                }
            }
        }
    }
}

