/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.tectonic;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import dev.worldgen.tectonic.config.ConfigHandler;
import java.nio.file.Path;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tectonic {
    public static final String MOD_ID = "tectonic";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"tectonic");
    public static int BLENDING_VERSION = 1;
    public static String BLENDING_KEY = "tectonic:blending_version";

    public static void init(Path folder) {
        ConfigHandler.load(folder.resolve("tectonic.json"));
    }

    public static ResourceLocation idVanilla(String name) {
        return new ResourceLocation(name);
    }

    public static ResourceLocation id(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public static int getBlendingVersion(CompoundTag tag) {
        return tag.m_128451_(BLENDING_KEY);
    }

    public static <T, U> Codec<T> withAlternative(Codec<T> primary, Codec<U> alternative, Function<U, T> converter) {
        return Codec.either(primary, alternative).xmap(either -> either.map(v -> v, converter), Either::left);
    }

    public static boolean isEnabled() {
        return ConfigHandler.getState().general.modEnabled;
    }
}

