/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.tectonic.client.gui;

import dev.worldgen.tectonic.client.ConfigListBuilder;
import dev.worldgen.tectonic.client.gui.ConfigScreen;
import dev.worldgen.tectonic.client.gui.widget.FixedStringWidget;
import dev.worldgen.tectonic.client.gui.widget.SliderWidget;
import dev.worldgen.tectonic.config.state.object.NoiseState;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ConfigList
extends ContainerObjectSelectionList<Entry>
implements ConfigListBuilder {
    public ConfigList(Minecraft minecraft, ConfigScreen parent) {
        super(minecraft, parent.f_96543_, parent.f_96544_, 32, parent.f_96544_ - 32, 25);
    }

    @Override
    public void addCategory(String name, Font font) {
        this.addEntry((AbstractWidget)new FixedStringWidget(ConfigScreen.text("category." + name), font));
    }

    @Override
    public void addBoolean(String name, Consumer<Boolean> setter, boolean value, boolean base) {
        CycleButton.Builder button = CycleButton.m_168916_((boolean)value);
        MutableComponent text = Component.m_237119_();
        text.m_7220_(ConfigScreen.option(name + ".tooltip"));
        text.m_7220_(CommonComponents.f_178388_);
        text.m_7220_((Component)Component.m_237115_((String)"config.tectonic.default"));
        text.m_130946_(base ? "\u00a7eON" : "\u00a7eOFF");
        button.m_232498_(__ -> Tooltip.m_257550_((Component)text));
        this.addEntry((AbstractWidget)button.m_168936_(0, 0, 150, 20, ConfigScreen.option(name), (__, bool) -> setter.accept((Boolean)bool)));
    }

    @Override
    public void addInteger(String name, double min, double max, double step, Consumer<Integer> action, double value, double base) {
        this.addEntry(new SliderWidget(min, max, step, "option." + name, newValue -> action.accept(newValue.intValue()), value, true, base));
    }

    @Override
    public void addDouble(String name, double min, double max, double step, Consumer<Double> action, double value, double base) {
        this.addEntry(new SliderWidget(min, max, step, "option." + name, action, value, false, base));
    }

    @Override
    public void addNoise(String name, NoiseState state, NoiseState baseState) {
        this.addDouble(name + "_scale", 0.0, 1.0, 0.01, value -> {
            state.scale = value;
        }, state.scale, baseState.scale);
        this.addDouble(name + "_multiplier", 0.0, 5.0, 0.1, value -> {
            state.multiplier = value;
        }, state.multiplier, baseState.multiplier);
        this.addDouble(name + "_offset", -1.0, 1.0, 0.01, value -> {
            state.offset = value;
        }, state.offset, baseState.offset);
    }

    public void addEntry(AbstractWidget widget) {
        widget.m_252865_(this.f_93388_ / 2 - 155);
        widget.m_253211_(0);
        widget.m_93674_(310);
        this.m_7085_((AbstractSelectionList.Entry)new Entry(widget));
    }

    protected int m_5756_() {
        return this.f_93388_ / 2 + 164;
    }

    public int m_5759_() {
        return 310;
    }

    static class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        final AbstractWidget widget;

        Entry(AbstractWidget widget) {
            this.widget = widget;
        }

        public void m_6311_(GuiGraphics p_281353_, int p_283181_, int p_282820_, int p_282420_, int p_281855_, int p_283204_, int p_283025_, int p_283396_, boolean p_282938_, float partialTick) {
            this.widget.m_253211_(p_282820_);
            this.widget.m_88315_(p_281353_, p_283025_, p_283396_, partialTick);
        }

        public List<? extends GuiEventListener> m_6702_() {
            return List.of(this.widget);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return List.of(this.widget);
        }
    }
}

