/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.tectonic;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.MapCodec;
import dev.worldgen.lithostitched.registry.LithostitchedRegistryKeys;
import dev.worldgen.tectonic.ConfigResourceCondition;
import dev.worldgen.tectonic.Tectonic;
import dev.worldgen.tectonic.command.TectonicCommand;
import dev.worldgen.tectonic.config.ConfigHandler;
import dev.worldgen.tectonic.lithostitched.SetHeightLimitsModifier;
import dev.worldgen.tectonic.worldgen.densityfunction.ConfigClamp;
import dev.worldgen.tectonic.worldgen.densityfunction.ConfigConstant;
import dev.worldgen.tectonic.worldgen.densityfunction.ConfigNoise;
import dev.worldgen.tectonic.worldgen.densityfunction.Invert;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.CompositePackResources;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.jarcontents.JarContents;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.registries.RegisterEvent;
import net.neoforged.neoforge.resource.JarContentsPackResources;
import net.neoforged.neoforgespi.language.IModInfo;
import org.apache.maven.artifact.versioning.ArtifactVersion;

@Mod(value="tectonic")
public class TectonicNeoforge {
    public static final DeferredRegister<MapCodec<? extends ICondition>> CONDITION_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.CONDITION_CODECS, (String)"tectonic");
    public static final DeferredHolder<MapCodec<? extends ICondition>, MapCodec<ConfigResourceCondition>> TECTONIC = CONDITION_TYPES.register("config", () -> ConfigResourceCondition.CODEC);

    public TectonicNeoforge(IEventBus bus) {
        Tectonic.init(FMLPaths.CONFIGDIR.get());
        CONDITION_TYPES.register(bus);
        bus.addListener(this::registerDensityFunctionTypes);
        bus.addListener(this::registerEnabledPacks);
        NeoForge.EVENT_BUS.addListener(this::registerCommands);
    }

    private void registerDensityFunctionTypes(RegisterEvent event) {
        event.register(Registries.DENSITY_FUNCTION_TYPE, helper -> {
            helper.register(Tectonic.id("config_clamp"), (Object)ConfigClamp.CODEC_HOLDER.codec());
            helper.register(Tectonic.id("config_constant"), (Object)ConfigConstant.CODEC_HOLDER.codec());
            helper.register(Tectonic.id("config_noise"), (Object)ConfigNoise.CODEC_HOLDER.codec());
            helper.register(Tectonic.id("invert"), (Object)Invert.CODEC_HOLDER.codec());
        });
        event.register(LithostitchedRegistryKeys.MODIFIER_TYPE, helper -> helper.register(Tectonic.id("set_height_limits"), SetHeightLimitsModifier.CODEC));
    }

    private void registerEnabledPacks(AddPackFindersEvent event) {
        if (ConfigHandler.getState().general.modEnabled) {
            TectonicNeoforge.addPackFinders(event, ResourceLocation.fromNamespaceAndPath((String)"tectonic", (String)"resourcepacks/tectonic"), PackType.SERVER_DATA, (Component)Component.literal((String)"Tectonic"), PackSource.BUILT_IN, true, Pack.Position.TOP);
        }
    }

    public static void addPackFinders(AddPackFindersEvent event, ResourceLocation location, PackType type, Component name, PackSource source, boolean alwaysActive, Pack.Position position) {
        if (event.getPackType() == type) {
            IModInfo modInfo = ((ModContainer)ModList.get().getModContainerById(location.getNamespace()).orElseThrow(() -> new IllegalArgumentException("Mod not found: " + location.getNamespace()))).getModInfo();
            ArtifactVersion version = modInfo.getVersion();
            final BiFunction<PackLocationInfo, String, PackResources> resourceGetter = (info, prefix) -> {
                JarContents contents = modInfo.getOwningFile().getFile().getContents();
                return new JarContentsPackResources(info, contents, prefix);
            };
            final String path = location.getPath();
            Pack pack = Pack.readMetaAndCreate((PackLocationInfo)new PackLocationInfo("mod/" + String.valueOf(location), name, source, Optional.of(new KnownPack("neoforge", "mod/" + String.valueOf(location), version.toString()))), (Pack.ResourcesSupplier)new Pack.ResourcesSupplier(){

                public PackResources openPrimary(PackLocationInfo info) {
                    return (PackResources)resourceGetter.apply(info, path);
                }

                public PackResources openFull(PackLocationInfo info, Pack.Metadata metadata) {
                    PackResources baseResources = (PackResources)resourceGetter.apply(info, path);
                    List overlays = metadata.overlays();
                    if (overlays.isEmpty()) {
                        return baseResources;
                    }
                    ArrayList<PackResources> effectiveOverlays = new ArrayList<PackResources>(overlays.size());
                    for (String s : overlays) {
                        effectiveOverlays.add((PackResources)resourceGetter.apply(info, path + "/" + s));
                    }
                    return new CompositePackResources(baseResources, effectiveOverlays);
                }
            }, (PackType)type, (PackSelectionConfig)new PackSelectionConfig(alwaysActive, position, false));
            event.addRepositorySource(consumer -> consumer.accept(pack));
        }
    }

    private void registerCommands(RegisterCommandsEvent event) {
        TectonicCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

