/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.tectonic.worldgen.densityfunction;

import com.mojang.serialization.MapCodec;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public record Invert(DensityFunction input, double min, double max) implements DensityFunction
{
    public static final MapCodec<Invert> DATA_CODEC = DensityFunction.HOLDER_HELPER_CODEC.fieldOf("argument").xmap(Invert::create, Invert::input);
    public static KeyDispatchDataCodec<Invert> CODEC_HOLDER = KeyDispatchDataCodec.of(DATA_CODEC);

    public static Invert create(DensityFunction input) {
        double min = input.minValue();
        double max = input.maxValue();
        if (min < 0.0 && max > 0.0) {
            return new Invert(input, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        }
        return new Invert(input, min, max);
    }

    public double transform(double d) {
        return 1.0 / d;
    }

    public double compute(DensityFunction.FunctionContext functionContext) {
        return this.transform(this.input().compute(functionContext));
    }

    public void fillArray(double[] densities, DensityFunction.ContextProvider context) {
        this.input().fillArray(densities, context);
        for (int i = 0; i < densities.length; ++i) {
            densities[i] = this.transform(densities[i]);
        }
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return Invert.create(this.input.mapAll(visitor));
    }

    public double minValue() {
        return this.min;
    }

    public double maxValue() {
        return this.max;
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC_HOLDER;
    }
}

