/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.tectonic.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import net.minecraft.client.InputType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class SliderWidget
extends AbstractWidget {
    private static final ResourceLocation SLIDER_LOCATION = new ResourceLocation("textures/gui/slider.png");
    private final double min;
    private final double max;
    private final double step;
    private final String name;
    private final Consumer<Double> action;
    protected double delta;
    protected double value;
    private boolean canChangeValue;
    protected boolean displayInt;

    public SliderWidget(double min, double max, double step, String suffix, Consumer<Double> action, double value, boolean displayInt, double base) {
        super(0, 0, 310, 20, CommonComponents.f_237098_);
        this.min = min;
        this.max = max;
        this.step = 1.0 / step;
        this.name = "config.tectonic." + suffix;
        this.action = action;
        this.value = value;
        this.delta = this.valueToDelta();
        this.displayInt = displayInt;
        MutableComponent text = Component.m_237119_();
        text.m_7220_((Component)Component.m_237115_((String)(this.name + ".tooltip")));
        text.m_7220_(CommonComponents.f_178388_);
        text.m_7220_((Component)Component.m_237115_((String)"config.tectonic.default"));
        if (this.displayInt) {
            text.m_130946_("\u00a7e" + (int)base);
        } else {
            text.m_130946_("\u00a7e" + base);
        }
        this.m_257544_(Tooltip.m_257550_((Component)text));
        this.updateMessage();
    }

    private int getTextureY() {
        int i = this.m_93696_() && !this.canChangeValue ? 1 : 0;
        return i * 20;
    }

    private int getHandleTextureY() {
        int i = !this.f_93622_ && !this.canChangeValue ? 2 : 3;
        return i * 20;
    }

    protected MutableComponent m_5646_() {
        return Component.m_237110_((String)"gui.narrate.slider", (Object[])new Object[]{this.m_6035_()});
    }

    public void m_168797_(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.m_169146_(NarratedElementType.TITLE, (Component)this.m_5646_());
        if (this.f_93623_) {
            if (this.m_93696_()) {
                narrationElementOutput.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"narration.slider.usage.focused"));
            } else {
                narrationElementOutput.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"narration.slider.usage.hovered"));
            }
        }
    }

    public void m_87963_(GuiGraphics p_261774_, int p_261640_, int p_261514_, float partialTick) {
        Minecraft minecraft = Minecraft.m_91087_();
        p_261774_.m_280246_(1.0f, 1.0f, 1.0f, this.f_93625_);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        p_261774_.m_280027_(SLIDER_LOCATION, this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), 20, 4, 200, 20, 0, this.getTextureY());
        p_261774_.m_280027_(SLIDER_LOCATION, this.m_252754_() + (int)(this.delta * (double)(this.f_93618_ - 8)), this.m_252907_(), 8, 20, 20, 4, 200, 20, 0, this.getHandleTextureY());
        p_261774_.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        int k = this.f_93623_ ? 0xFFFFFF : 0xA0A0A0;
        this.m_280372_(p_261774_, minecraft.f_91062_, 2, k | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
    }

    public void m_5716_(double p_279437_, double mouseY) {
        this.setValueFromMouse(p_279437_);
    }

    public void m_93692_(boolean focused) {
        super.m_93692_(focused);
        if (!focused) {
            this.canChangeValue = false;
        } else {
            InputType inputtype = Minecraft.m_91087_().m_264529_();
            if (inputtype == InputType.MOUSE || inputtype == InputType.KEYBOARD_TAB) {
                this.canChangeValue = true;
            }
        }
    }

    public boolean m_7933_(int p_193988_, int p_193989_, int modifiers) {
        if (CommonInputs.m_278691_((int)p_193988_)) {
            this.canChangeValue = !this.canChangeValue;
            return true;
        }
        if (this.canChangeValue) {
            boolean flag;
            boolean bl = flag = p_193988_ == 263;
            if (flag || p_193988_ == 262) {
                float f = flag ? -1.0f : 1.0f;
                this.setValue(this.delta + (double)(f / (float)(this.f_93618_ - 8)));
                return true;
            }
        }
        return false;
    }

    private void setValueFromMouse(double mouseX) {
        this.setValue((mouseX - (double)(this.m_252754_() + 4)) / (double)(this.f_93618_ - 8));
    }

    private void setValue(double value) {
        double d0 = this.delta;
        this.delta = Mth.m_14008_((double)value, (double)0.0, (double)1.0);
        this.value = this.deltaToValue();
        if (d0 != this.delta) {
            this.action.accept(this.value);
        }
        this.updateMessage();
    }

    private double deltaToValue() {
        double lerped = Mth.m_14139_((double)this.delta, (double)this.min, (double)this.max);
        return (double)Math.round(lerped * this.step) / this.step;
    }

    private double valueToDelta() {
        return (this.value - this.min) / (this.max - this.min);
    }

    protected void m_7212_(double p_93637_, double p_93639_, double dragX, double dragY) {
        this.setValueFromMouse(p_93637_);
        super.m_7212_(p_93637_, p_93639_, dragX, dragY);
    }

    public void m_7435_(SoundManager handler) {
    }

    public void m_7691_(double p_93610_, double mouseY) {
        super.m_7435_(Minecraft.m_91087_().m_91106_());
    }

    private void updateMessage() {
        if (this.displayInt) {
            this.m_93666_((Component)Component.m_237110_((String)this.name, (Object[])new Object[]{(int)this.value}));
        } else {
            this.m_93666_((Component)Component.m_237110_((String)this.name, (Object[])new Object[]{this.value}));
        }
    }
}

