/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.tectonic.mixin;

import dev.worldgen.tectonic.Tectonic;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.storage.ChunkSerializer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChunkSerializer.class})
public class ChunkSerializerMixin {
    @Unique
    private static final Set<String> STATUSES_TO_SKIP_BLENDING = Set.of("minecraft:empty", "minecraft:structure_starts", "minecraft:structure_references", "minecraft:biomes");

    @Inject(method={"m_188230_(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/ai/village/poi/PoiManager;Lnet/minecraft/world/level/ChunkPos;Lnet/minecraft/nbt/CompoundTag;)Lnet/minecraft/world/level/chunk/ProtoChunk;"}, at={@At(value="HEAD")})
    private static void tectonic$read(ServerLevel level, PoiManager poiManager, ChunkPos chunkPos, CompoundTag nbt, CallbackInfoReturnable<ProtoChunk> cir) {
        if (!level.m_46472_().equals((Object)Level.f_46428_)) {
            return;
        }
        if (STATUSES_TO_SKIP_BLENDING.contains(ChunkStatus.m_62397_((String)nbt.m_128461_("Status")).toString())) {
            return;
        }
        if (nbt.m_128451_(Tectonic.BLENDING_KEY) != Tectonic.BLENDING_VERSION) {
            int min = 0;
            int max = 0;
            ListTag sections = nbt.m_128437_("sections", 10);
            for (Tag section : sections) {
                int n;
                if (section instanceof IntTag) {
                    IntTag tag = (IntTag)section;
                    n = tag.m_7047_();
                } else {
                    n = 0;
                }
                int y = n;
                min = Math.min(y, min);
                max = Math.max(y, max);
            }
            min = Math.min(min, -4);
            max = Math.max(max, 20);
            CompoundTag blendingData = new CompoundTag();
            blendingData.m_128405_("min_section", min);
            blendingData.m_128405_("max_section", max);
            nbt.m_128365_("blending_data", (Tag)blendingData);
            nbt.m_128473_("Heightmaps");
            nbt.m_128473_("isLightOn");
        }
    }

    @Inject(method={"m_63454_(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/chunk/ChunkAccess;)Lnet/minecraft/nbt/CompoundTag;"}, at={@At(value="RETURN")}, cancellable=true)
    private static void tectonic$write(ServerLevel serverLevel, ChunkAccess chunkAccess, CallbackInfoReturnable<CompoundTag> cir) {
        if (Tectonic.BLENDING_VERSION == 0) {
            return;
        }
        CompoundTag data = (CompoundTag)cir.getReturnValue();
        data.m_128405_(Tectonic.BLENDING_KEY, Tectonic.BLENDING_VERSION);
        cir.setReturnValue((Object)data);
    }
}

