/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.tectonic.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.worldgen.tectonic.Tectonic;
import dev.worldgen.tectonic.config.state.ConfigState;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.util.GsonHelper;

public class ConfigHandler {
    private static ConfigState LOADED_STATE = new ConfigState(1, ConfigState.General.DEFAULT, ConfigState.GlobalTerrain.DEFAULT, ConfigState.Continents.DEFAULT, ConfigState.Islands.DEFAULT, ConfigState.Oceans.DEFAULT, ConfigState.Biomes.DEFAULT, ConfigState.Caves.DEFAULT);
    private static Path PATH;

    public static ConfigState getState() {
        return LOADED_STATE;
    }

    public static void setState(ConfigState state) {
        LOADED_STATE = state;
    }

    public static void load(Path path) {
        block11: {
            PATH = path;
            if (!Files.isRegularFile(path, new LinkOption[0])) {
                ConfigHandler.save();
            }
            try (BufferedReader reader = Files.newBufferedReader(path);){
                JsonElement json = JsonParser.parseReader((Reader)reader);
                Optional result = ConfigState.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).result();
                if (result.isPresent()) {
                    LOADED_STATE = (ConfigState)result.get();
                    break block11;
                }
                throw new JsonParseException("Invalid codec");
            }
            catch (JsonParseException e) {
                Tectonic.LOGGER.error("Couldn't parse config file, resetting to default config");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        ConfigHandler.save();
    }

    public static void save() {
        try (BufferedWriter writer = Files.newBufferedWriter(PATH, new OpenOption[0]);){
            JsonElement element = (JsonElement)ConfigState.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)LOADED_STATE).result().get();
            StringWriter stringWriter = new StringWriter();
            JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
            jsonWriter.setIndent("  ");
            GsonHelper.writeValue((JsonWriter)jsonWriter, (JsonElement)element, Comparator.naturalOrder());
            writer.write(stringWriter.toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

