/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.tectonic.worldgen.densityfunction;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.tectonic.config.ConfigHandler;
import dev.worldgen.tectonic.config.state.object.NoiseState;
import net.minecraft.core.Holder;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;

public record ConfigNoise(DensityFunction.NoiseHolder noise, DensityFunction shiftX, DensityFunction shiftZ, double scale, double multiplier, double offset) implements DensityFunction
{
    public static MapCodec<ConfigNoise> DATA_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("key").forGetter(df -> ""), (App)DensityFunction.NoiseHolder.CODEC.fieldOf("noise").forGetter(ConfigNoise::noise), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("shift_x").forGetter(ConfigNoise::shiftX), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("shift_z").forGetter(ConfigNoise::shiftZ)).apply((Applicative)instance, ConfigNoise::create));
    public static KeyDispatchDataCodec<ConfigNoise> CODEC_HOLDER = KeyDispatchDataCodec.of(DATA_CODEC);

    public static ConfigNoise create(String key, DensityFunction.NoiseHolder noise, DensityFunction shiftX, DensityFunction shiftZ) {
        NoiseState state = ConfigHandler.getState().getNoiseState(key);
        return new ConfigNoise(noise, shiftX, shiftZ, state.scale, state.multiplier, state.offset);
    }

    public double compute(DensityFunction.FunctionContext context) {
        double x = (double)context.blockX() * this.scale + this.shiftX.compute(context);
        double z = (double)context.blockZ() * this.scale + this.shiftZ.compute(context);
        return this.noise.getValue(x, 0.0, z) * this.multiplier + this.offset;
    }

    public void fillArray(double[] doubles, DensityFunction.ContextProvider contextProvider) {
        contextProvider.fillAllDirectly(doubles, (DensityFunction)this);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return DensityFunctions.add((DensityFunction)DensityFunctions.mul((DensityFunction)DensityFunctions.shiftedNoise2d((DensityFunction)this.shiftX, (DensityFunction)this.shiftZ, (double)this.scale, (Holder)this.noise.noiseData()), (DensityFunction)DensityFunctions.constant((double)this.multiplier)), (DensityFunction)DensityFunctions.constant((double)this.offset)).mapAll(visitor);
    }

    public double minValue() {
        return -this.maxValue();
    }

    public double maxValue() {
        return this.noise.maxValue();
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC_HOLDER;
    }
}

