/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.tectonic;

import com.mojang.brigadier.CommandDispatcher;
import dev.worldgen.lithostitched.registry.LithostitchedBuiltInRegistries;
import dev.worldgen.tectonic.Tectonic;
import dev.worldgen.tectonic.TectonicModifierPredicate;
import dev.worldgen.tectonic.TectonicRepositorySource;
import dev.worldgen.tectonic.command.TectonicCommand;
import dev.worldgen.tectonic.config.ConfigHandler;
import dev.worldgen.tectonic.lithostitched.SetHeightLimitsModifier;
import dev.worldgen.tectonic.worldgen.densityfunction.ConfigConstant;
import dev.worldgen.tectonic.worldgen.densityfunction.ConfigNoise;
import dev.worldgen.tectonic.worldgen.densityfunction.Invert;
import java.nio.file.Path;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2168;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3259;
import net.minecraft.class_3264;
import net.minecraft.class_3288;
import net.minecraft.class_5352;
import net.minecraft.class_7923;

public class TectonicFabric
implements ModInitializer {
    public void onInitialize() {
        Tectonic.init(FabricLoader.getInstance().getConfigDir());
        CommandRegistrationCallback.EVENT.register((dispatcher, context, selection) -> TectonicCommand.register((CommandDispatcher<class_2168>)dispatcher));
        class_2378.method_10230((class_2378)class_7923.field_41160, (class_2960)Tectonic.id("config_constant"), (Object)ConfigConstant.CODEC_HOLDER.comp_640());
        class_2378.method_10230((class_2378)class_7923.field_41160, (class_2960)Tectonic.id("config_noise"), (Object)ConfigNoise.CODEC_HOLDER.comp_640());
        class_2378.method_10230((class_2378)class_7923.field_41160, (class_2960)Tectonic.id("invert"), (Object)Invert.CODEC_HOLDER.comp_640());
        class_2378.method_10230((class_2378)LithostitchedBuiltInRegistries.MODIFIER_TYPE, (class_2960)Tectonic.id("set_height_limits"), SetHeightLimitsModifier.CODEC);
        class_2378.method_10230((class_2378)LithostitchedBuiltInRegistries.MODIFIER_PREDICATE_TYPE, (class_2960)Tectonic.id("config"), TectonicModifierPredicate.CODEC);
        if (ConfigHandler.getState().general.modEnabled) {
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)Tectonic.id("tectonic"), (ModContainer)((ModContainer)FabricLoader.getInstance().getModContainer("tectonic").get()), (class_2561)class_2561.method_43470((String)"Tectonic"), (ResourcePackActivationType)ResourcePackActivationType.ALWAYS_ENABLED);
            boolean terralith = FabricLoader.getInstance().isModLoaded("terralith");
            boolean ultrasmooth = ConfigHandler.getState().globalTerrain.ultrasmooth;
            boolean noCarvers = !ConfigHandler.getState().caves.carversEnabled;
            TectonicFabric.addPack("tectonic/overlay.mod");
            if (terralith) {
                TectonicFabric.addPack("tectonic/overlay.terratonic");
            }
            if (ultrasmooth) {
                TectonicFabric.addPack("tectonic/overlay.ultrasmooth");
            }
            if (noCarvers) {
                TectonicFabric.addPack("tectonic/overlay.no_carvers");
            }
        }
    }

    private static void addPack(String packName) {
        Path resourcePath = (Path)((ModContainer)FabricLoader.getInstance().getModContainer("tectonic").get()).findPath("resourcepacks/" + packName).get();
        TectonicRepositorySource.PACKS.add(class_3288.method_45275((String)("tectonic/" + packName.toLowerCase()), (class_2561)class_2561.method_43471((String)("pack_name.tectonic." + packName)), (boolean)false, string -> new class_3259(resourcePath.getFileName().toString(), resourcePath, false), (class_3264)class_3264.field_14190, (class_3288.class_3289)class_3288.class_3289.field_14280, (class_5352)class_5352.field_25348));
    }
}

