/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.tectonic.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.worldgen.lithostitched.mixin.common.RandomStateAccessor;
import dev.worldgen.lithostitched.worldgen.NoiseWiringHelper;
import dev.worldgen.tectonic.Tectonic;
import dev.worldgen.tectonic.config.ConfigHandler;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3754;
import net.minecraft.class_5250;
import net.minecraft.class_5284;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6910;
import net.minecraft.class_7138;
import net.minecraft.class_7225;
import net.minecraft.class_7871;
import net.minecraft.class_7924;

public class TectonicCommand {
    private static final class_5321<class_6910> EROSION = TectonicCommand.key("noise/continent/erosion");
    private static final class_5321<class_6910> REGION_SELECTOR = TectonicCommand.key("noise/region_selector");
    private static final class_5321<class_6910> DEPTH_CUTOFF = TectonicCommand.key("__constants/cave/depth_cutoff");

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tectonic").requires(stack -> stack.method_9259(2))).executes(TectonicCommand::run));
    }

    private static int run(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3218 level = source.method_9225();
        class_2338 pos = source.method_9207().method_24515();
        if (!ConfigHandler.getState().general.modEnabled) {
            TectonicCommand.failure(source, "Tectonic is not currently enabled.");
            return 0;
        }
        class_2794 class_27942 = level.method_14178().method_12129();
        if (!(class_27942 instanceof class_3754)) {
            TectonicCommand.failure(source, "Tectonic generation is not present here.");
            return 0;
        }
        class_3754 generator = (class_3754)class_27942;
        TectonicCommand.message(source, (class_2561)class_2561.method_43470((String)"Tectonic debug info:"));
        class_5284 settings = (class_5284)generator.method_41541().comp_349();
        class_7138 randomState = class_7138.method_41556((class_5284)settings, (class_7871)level.method_30349().method_46762(class_7924.field_41244), (long)level.method_8412());
        NoiseWiringHelper helper = new NoiseWiringHelper(level.method_8412(), settings.comp_483(), randomState, ((RandomStateAccessor)randomState).getRandom());
        class_7225.class_7226 registry = level.method_30349().method_46762(class_7924.field_41240);
        TectonicCommand.message(source, TectonicCommand.getRegion(TectonicCommand.get((class_6880<class_6910>)registry.method_46747(EROSION), helper, pos), TectonicCommand.get((class_6880<class_6910>)registry.method_46747(REGION_SELECTOR), helper, pos)));
        TectonicCommand.message(source, (class_2561)class_2561.method_48322((String)"command.tectonic.depth_cutoff", (String)"Depth cutoff: %s", (Object[])new Object[]{TectonicCommand.get((class_6880<class_6910>)registry.method_46747(DEPTH_CUTOFF), helper, pos)}));
        return 1;
    }

    private static void message(class_2168 source, class_2561 message) {
        source.method_45068(message);
    }

    private static void failure(class_2168 source, String message) {
        source.method_9213((class_2561)class_2561.method_43470((String)message));
    }

    private static double get(class_6880<class_6910> holder, NoiseWiringHelper helper, class_2338 pos) {
        double d = ((class_6910)holder.comp_349()).method_40469((class_6910.class_6915)helper).method_40464((class_6910.class_6912)new class_6910.class_6914(pos.method_10263(), pos.method_10264(), pos.method_10260()));
        return (double)Math.round(d * 1000.0) / 1000.0;
    }

    private static class_2561 getRegion(double erosion, double regionSelector) {
        String nameText;
        String iconText;
        if (erosion < 0.0) {
            if (regionSelector < 0.0) {
                iconText = "\u2663";
                nameText = "Club";
            } else {
                iconText = "\u2665";
                nameText = "Heart";
            }
        } else if (regionSelector < 0.0) {
            iconText = "\u2660";
            nameText = "Spade";
        } else {
            iconText = "\u2666";
            nameText = "Diamond";
        }
        class_5250 icon = class_2561.method_43470((String)iconText);
        icon.method_27692(regionSelector < 0.0 ? class_124.field_1063 : class_124.field_1061);
        class_5250 name = class_2561.method_43470((String)nameText);
        return class_2561.method_48322((String)"command.tectonic.region", (String)"Region: %s %s (Erosion %s / Region Selector %s)", (Object[])new Object[]{icon, name, erosion, regionSelector});
    }

    private static double round(double erosion) {
        return (double)Math.round(erosion * 1000.0) / 1000.0;
    }

    private static class_5321<class_6910> key(String name) {
        return class_5321.method_29179((class_5321)class_7924.field_41240, (class_2960)Tectonic.id(name));
    }
}

