/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.tectonic.client.gui;

import dev.worldgen.tectonic.client.gui.ConfigScreen;
import dev.worldgen.tectonic.config.ConfigHandler;
import dev.worldgen.tectonic.config.state.ConfigPresets;
import dev.worldgen.tectonic.config.state.ConfigState;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.util.TriConsumer;

public class PresetSelectorScreen
extends Screen {
    private final ConfigScreen parent;
    private PresetList list;
    final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this);

    public PresetSelectorScreen(ConfigScreen parent) {
        super(PresetSelectorScreen.text("title"));
        this.parent = parent;
    }

    public void init() {
        this.layout.addTitleHeader(this.title, this.font);
        this.list = (PresetList)this.layout.addToContents((LayoutElement)new PresetList(this.minecraft, this.width, this));
        ConfigPresets.acceptPresets((TriConsumer<String, ConfigState, Integer>)((TriConsumer)this.list::addEntry));
        LinearLayout footer = (LinearLayout)this.layout.addToFooter((LayoutElement)LinearLayout.horizontal().spacing(8));
        footer.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> this.onClose()).build());
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    protected void repositionElements() {
        this.layout.arrangeElements();
        if (this.list != null) {
            this.list.updateSize(this.width, this.layout);
        }
    }

    public void onClose() {
        this.minecraft.setScreen((Screen)new ConfigScreen(this.parent.parent));
    }

    public static Component text(String name) {
        return Component.translatable((String)("preset.tectonic." + name));
    }

    public class PresetList
    extends ContainerObjectSelectionList<Entry> {
        public PresetList(Minecraft minecraft, int width, PresetSelectorScreen parent) {
            super(minecraft, width, parent.layout.getContentHeight(), parent.layout.getHeaderHeight(), 25);
        }

        public void addEntry(String name, ConfigState state, int color) {
            this.addEntry((AbstractSelectionList.Entry)new Entry(name, state, color));
        }

        public int getRowWidth() {
            return 310;
        }

        public void updateSize(int width, HeaderAndFooterLayout layout) {
            super.updateSize(width, layout);
            this.children().forEach(entry -> entry.widget.setX(width / 2 - 155));
        }

        public class Entry
        extends ContainerObjectSelectionList.Entry<Entry> {
            final Button widget;
            final ConfigState state;

            Entry(String name, ConfigState state, int color) {
                this.widget = Button.builder((Component)PresetSelectorScreen.text(name).copy().withColor(color), this::select).width(310).build();
                this.state = state;
            }

            private void select(Button button) {
                ConfigHandler.setState(this.state);
                ConfigHandler.save();
                PresetSelectorScreen.this.onClose();
            }

            public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovering, float partialTick) {
                this.widget.setY(this.getY());
                this.widget.render(guiGraphics, mouseX, mouseY, partialTick);
            }

            public List<? extends GuiEventListener> children() {
                return List.of(this.widget);
            }

            public List<? extends NarratableEntry> narratables() {
                return List.of(this.widget);
            }
        }
    }
}

