/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.tectonic.client.gui.widget;

import java.util.function.Consumer;
import net.minecraft.client.InputType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;

public class SliderWidget
extends AbstractWidget {
    private static final ResourceLocation SLIDER_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/slider");
    private static final ResourceLocation HIGHLIGHTED_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/slider_highlighted");
    private static final ResourceLocation SLIDER_HANDLE_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/slider_handle");
    private static final ResourceLocation SLIDER_HANDLE_HIGHLIGHTED_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/slider_handle_highlighted");
    private final double min;
    private final double max;
    private final double step;
    private final String name;
    private final Consumer<Double> action;
    protected double delta;
    protected double value;
    private boolean canChangeValue;
    protected boolean displayInt;

    public SliderWidget(double min, double max, double step, String suffix, Consumer<Double> action, double value, boolean displayInt, double base) {
        super(0, 0, 0, 0, CommonComponents.EMPTY);
        this.min = min;
        this.max = max;
        this.step = 1.0 / step;
        this.name = "config.tectonic." + suffix;
        this.action = action;
        this.value = value;
        this.delta = this.valueToDelta();
        this.displayInt = displayInt;
        MutableComponent text = Component.empty();
        text.append((Component)Component.translatable((String)(this.name + ".tooltip")));
        text.append(CommonComponents.NEW_LINE);
        text.append((Component)Component.translatable((String)"config.tectonic.default"));
        if (this.displayInt) {
            text.append("\u00a7e" + (int)base);
        } else {
            text.append("\u00a7e" + base);
        }
        this.setTooltip(Tooltip.create((Component)text));
        this.updateMessage();
    }

    private ResourceLocation getSprite() {
        return this.isFocused() && !this.canChangeValue ? HIGHLIGHTED_SPRITE : SLIDER_SPRITE;
    }

    private ResourceLocation getHandleSprite() {
        return !this.isHovered && !this.canChangeValue ? SLIDER_HANDLE_SPRITE : SLIDER_HANDLE_HIGHLIGHTED_SPRITE;
    }

    protected MutableComponent createNarrationMessage() {
        return Component.translatable((String)"gui.narrate.slider", (Object[])new Object[]{this.getMessage()});
    }

    public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.add(NarratedElementType.TITLE, (Component)this.createNarrationMessage());
        if (this.active) {
            if (this.isFocused()) {
                narrationElementOutput.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.slider.usage.focused"));
            } else {
                narrationElementOutput.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.slider.usage.hovered"));
            }
        }
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Minecraft minecraft = Minecraft.getInstance();
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, this.getSprite(), this.getX(), this.getY(), this.getWidth(), this.getHeight(), ARGB.white((float)this.alpha));
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, this.getHandleSprite(), this.getX() + (int)(this.delta * (double)(this.width - 8)), this.getY(), 8, this.getHeight(), ARGB.white((float)this.alpha));
        int k = this.active ? 0xFFFFFF : 0xA0A0A0;
        this.renderScrollingString(guiGraphics, minecraft.font, 2, k | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
    }

    public void onClick(MouseButtonEvent event, boolean bl) {
        this.setValueFromMouse(event.x());
    }

    public void setFocused(boolean focused) {
        super.setFocused(focused);
        if (!focused) {
            this.canChangeValue = false;
        } else {
            InputType inputtype = Minecraft.getInstance().getLastInputType();
            if (inputtype == InputType.MOUSE || inputtype == InputType.KEYBOARD_TAB) {
                this.canChangeValue = true;
            }
        }
    }

    public boolean keyPressed(KeyEvent event) {
        if (event.isSelection()) {
            this.canChangeValue = !this.canChangeValue;
            return true;
        }
        if (this.canChangeValue) {
            boolean flag;
            boolean bl = flag = event.key() == 263;
            if (flag || event.key() == 262) {
                float f = flag ? -1.0f : 1.0f;
                this.setValue(this.delta + (double)(f / (float)(this.width - 8)));
                return true;
            }
        }
        return false;
    }

    private void setValueFromMouse(double mouseX) {
        this.setValue((mouseX - (double)(this.getX() + 4)) / (double)(this.width - 8));
    }

    private void setValue(double value) {
        double d0 = this.delta;
        this.delta = Mth.clamp((double)value, (double)0.0, (double)1.0);
        this.value = this.deltaToValue();
        if (d0 != this.delta) {
            this.action.accept(this.value);
        }
        this.updateMessage();
    }

    private double deltaToValue() {
        double lerped = Mth.lerp((double)this.delta, (double)this.min, (double)this.max);
        return (double)Math.round(lerped * this.step) / this.step;
    }

    private double valueToDelta() {
        return (this.value - this.min) / (this.max - this.min);
    }

    protected void onDrag(MouseButtonEvent event, double dragX, double dragY) {
        this.setValueFromMouse(event.x());
        super.onDrag(event, dragX, dragY);
    }

    public void playDownSound(SoundManager handler) {
    }

    public void onRelease(MouseButtonEvent event) {
        super.playDownSound(Minecraft.getInstance().getSoundManager());
    }

    private void updateMessage() {
        if (this.displayInt) {
            this.setMessage((Component)Component.translatable((String)this.name, (Object[])new Object[]{(int)this.value}));
        } else {
            this.setMessage((Component)Component.translatable((String)this.name, (Object[])new Object[]{this.value}));
        }
    }
}

