/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.tectonic.lithostitched;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.mixin.common.MappedRegistryAccessor;
import dev.worldgen.lithostitched.worldgen.modifier.Modifier;
import dev.worldgen.tectonic.Tectonic;
import dev.worldgen.tectonic.config.ConfigHandler;
import dev.worldgen.tectonic.config.state.object.HeightLimits;
import dev.worldgen.tectonic.mixin.DimensionTypeAccessor;
import dev.worldgen.tectonic.mixin.NoiseSettingsAccessor;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;

public record SetHeightLimitsModifier(int priority, Holder<DimensionType> dimensionType, Holder<NoiseGeneratorSettings> noiseSettings) implements Modifier
{
    private final int priority;
    public static final MapCodec<SetHeightLimitsModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Modifier.PRIORITY_DEFAULT.forGetter(SetHeightLimitsModifier::priority), (App)DimensionType.CODEC.fieldOf("dimension_type").forGetter(SetHeightLimitsModifier::dimensionType), (App)NoiseGeneratorSettings.CODEC.fieldOf("noise_settings").forGetter(SetHeightLimitsModifier::noiseSettings)).apply((Applicative)instance, SetHeightLimitsModifier::new));

    public void applyModifier(RegistryAccess registries) {
        if (!Tectonic.isEnabled()) {
            return;
        }
        HeightLimits limits = ConfigHandler.getState().globalTerrain.heightLimits;
        DimensionTypeAccessor typeAccessor = (DimensionTypeAccessor)this.dimensionType.value();
        typeAccessor.setMinY(limits.minY);
        typeAccessor.setHeight(limits.getHeight());
        typeAccessor.setLogicalHeight(limits.getHeight());
        NoiseSettingsAccessor settingsAccessor = (NoiseSettingsAccessor)((NoiseGeneratorSettings)this.noiseSettings.value()).noiseSettings();
        settingsAccessor.setMinY(limits.minY);
        settingsAccessor.setHeight(limits.getHeight());
        if (this.dimensionType.unwrapKey().isPresent()) {
            Registry registry = registries.lookupOrThrow(Registries.DIMENSION_TYPE);
            ResourceKey key = (ResourceKey)this.dimensionType.unwrapKey().get();
            Optional knownPackInfo = registry.registrationInfo(key);
            knownPackInfo.ifPresent(registrationInfo -> ((MappedRegistryAccessor)registry).lithostitched$getRegistrationInfos().put(key, new RegistrationInfo(Optional.empty(), registrationInfo.lifecycle())));
        }
    }

    public void applyModifier() {
    }

    public int priority() {
        return 0;
    }

    public MapCodec<SetHeightLimitsModifier> codec() {
        return CODEC;
    }
}

