/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.tectonic.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.worldgen.lithostitched.mixin.common.RandomStateAccessor;
import dev.worldgen.lithostitched.worldgen.NoiseWiringHelper;
import dev.worldgen.tectonic.Tectonic;
import dev.worldgen.tectonic.config.ConfigHandler;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2378;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3754;
import net.minecraft.class_5250;
import net.minecraft.class_5284;
import net.minecraft.class_5321;
import net.minecraft.class_6497;
import net.minecraft.class_6880;
import net.minecraft.class_6910;
import net.minecraft.class_7138;
import net.minecraft.class_7871;
import net.minecraft.class_7924;

public class TectonicCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder locate = class_2170.method_9247((String)"locate");
        TectonicCommand.addTarget((LiteralArgumentBuilder<class_2168>)locate, "mountain_range", LocateTargets.MOUNTAIN_RANGE, () -> true);
        TectonicCommand.addTarget((LiteralArgumentBuilder<class_2168>)locate, "underground_river", LocateTargets.UNDERGROUND_RIVER, () -> ConfigHandler.getState().continents.undergroundRivers);
        TectonicCommand.addTarget((LiteralArgumentBuilder<class_2168>)locate, "jungle_pillars", LocateTargets.JUNGLE_PILLARS, () -> ConfigHandler.getState().continents.junglePillars);
        TectonicCommand.addTarget((LiteralArgumentBuilder<class_2168>)locate, "rolling_hills", LocateTargets.ROLLING_HILLS, () -> ConfigHandler.getState().continents.rollingHills);
        TectonicCommand.addTarget((LiteralArgumentBuilder<class_2168>)locate, "badlands_canyon", LocateTargets.BADLANDS_CANYON, () -> true);
        TectonicCommand.addTarget((LiteralArgumentBuilder<class_2168>)locate, "badlands_plateaus", LocateTargets.BADLANDS_PLATEAUS, () -> true);
        TectonicCommand.addTarget((LiteralArgumentBuilder<class_2168>)locate, "desert_dunes", LocateTargets.DESERT_DUNES, () -> true);
        TectonicCommand.addTarget((LiteralArgumentBuilder<class_2168>)locate, "cherry_valley", LocateTargets.CHERRY_VALLEY, () -> true);
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tectonic").requires(stack -> stack.method_9259(2))).then(class_2170.method_9247((String)"debug").executes(TectonicCommand::debugOutput))).then((ArgumentBuilder)locate));
    }

    private static void addTarget(LiteralArgumentBuilder<class_2168> locate, String name, Map<String, class_6497<Double>> target, Supplier<Boolean> enabled) {
        locate.then(class_2170.method_9247((String)name).executes(context -> TectonicCommand.locate((CommandContext<class_2168>)context, name, target, enabled)));
    }

    private static int debugOutput(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_3218 level = source.method_9225();
        class_2338 origin = class_2338.method_49638((class_2374)source.method_9222());
        class_2378 registry = level.method_30349().method_30530(class_7924.field_41240);
        NoiseWiringHelper helper = TectonicCommand.getNoiseHelper(source);
        if (helper == null) {
            return 0;
        }
        TectonicCommand.message(source, (class_2561)class_2561.method_43470((String)"Tectonic debug info:"));
        TectonicCommand.message(source, TectonicCommand.getRegion(TectonicCommand.get((class_6880<class_6910>)registry.method_46747(TectonicCommand.key("noise/continent/erosion")), helper, origin), TectonicCommand.get((class_6880<class_6910>)registry.method_46747(TectonicCommand.key("noise/region_selector")), helper, origin)));
        TectonicCommand.message(source, (class_2561)class_2561.method_48322((String)"command.tectonic.depth_cutoff", (String)"Depth cutoff: %s", (Object[])new Object[]{TectonicCommand.get((class_6880<class_6910>)registry.method_46747(TectonicCommand.key("__constants/cave/depth_cutoff")), helper, origin)}));
        return 1;
    }

    private static int locate(CommandContext<class_2168> context, String name, Map<String, class_6497<Double>> targets, Supplier<Boolean> enabled) {
        class_2168 source = (class_2168)context.getSource();
        class_3218 level = source.method_9225();
        class_2338 origin = class_2338.method_49638((class_2374)source.method_9222());
        class_2378 registry = level.method_30349().method_30530(class_7924.field_41240);
        if (!enabled.get().booleanValue()) {
            TectonicCommand.failure(source, "Tectonic terrain feature " + name + " is not enabled.");
            return 0;
        }
        NoiseWiringHelper helper = TectonicCommand.getNoiseHelper(source);
        if (helper == null) {
            return 0;
        }
        for (class_2338.class_2339 offset : class_2338.method_30512((class_2338)class_2338.field_10980, (int)400, (class_2350)class_2350.field_11034, (class_2350)class_2350.field_11035)) {
            int x = origin.method_10263() + offset.method_10263() * 64;
            int z = origin.method_10260() + offset.method_10260() * 64;
            class_2338 pos = new class_2338(x, 0, z);
            boolean allMatch = true;
            for (Map.Entry<String, class_6497<Double>> target : targets.entrySet()) {
                if (target.getValue().method_37955((Comparable)Double.valueOf(TectonicCommand.get((class_6880<class_6910>)registry.method_46747(TectonicCommand.key(target.getKey())), helper, pos)))) continue;
                allMatch = false;
            }
            if (!allMatch) continue;
            class_5250 component = class_2564.method_10885((class_2561)class_2561.method_43469((String)"chat.coordinates", (Object[])new Object[]{pos.method_10263(), "~", pos.method_10260()})).method_27694(style -> style.method_10977(class_124.field_1060).method_10958(TectonicCommand.getClickEvent(pos)).method_10949(TectonicCommand.getHoverEvent()));
            int dist = class_3532.method_15375((float)TectonicCommand.dist(origin.method_10263(), origin.method_10260(), pos.method_10263(), pos.method_10260()));
            TectonicCommand.message(source, (class_2561)class_2561.method_48322((String)("command.tectonic.locate." + name), (String)("The nearest " + name + " is at %s (%s blocks away)"), (Object[])new Object[]{component, dist}));
            return 1;
        }
        TectonicCommand.message(source, (class_2561)class_2561.method_48321((String)"command.tectonic.locate_failed", (String)("Couldn't find " + name + " within a 25,000 block radius.")));
        return 0;
    }

    private static float dist(int x1, int z1, int x2, int z2) {
        int i = x2 - x1;
        int j = z2 - z1;
        return class_3532.method_15355((float)(i * i + j * j));
    }

    private static class_2558 getClickEvent(class_2338 pos) {
        return new class_2558.class_10610("/tp @s " + pos.method_10263() + " ~ " + pos.method_10260());
    }

    private static class_2568 getHoverEvent() {
        return new class_2568.class_10613((class_2561)class_2561.method_43471((String)"chat.coordinates.tooltip"));
    }

    private static NoiseWiringHelper getNoiseHelper(class_2168 source) {
        class_3218 level = source.method_9225();
        if (!ConfigHandler.getState().general.modEnabled) {
            TectonicCommand.failure(source, "Tectonic is not currently enabled.");
            return null;
        }
        class_2794 class_27942 = level.method_14178().method_12129();
        if (!(class_27942 instanceof class_3754)) {
            TectonicCommand.failure(source, "Tectonic generation is not present here.");
            return null;
        }
        class_3754 generator = (class_3754)class_27942;
        class_5284 settings = (class_5284)generator.method_41541().comp_349();
        class_7138 randomState = class_7138.method_41556((class_5284)settings, (class_7871)level.method_30349().method_30530(class_7924.field_41244), (long)level.method_8412());
        return new NoiseWiringHelper(level.method_8412(), settings.comp_483(), randomState, ((RandomStateAccessor)randomState).getRandom());
    }

    private static void message(class_2168 source, class_2561 message) {
        source.method_45068(message);
    }

    private static void failure(class_2168 source, String message) {
        source.method_9213((class_2561)class_2561.method_43470((String)message).method_27692(class_124.field_1061));
    }

    private static double get(class_6880<class_6910> holder, NoiseWiringHelper helper, class_2338 pos) {
        double d = ((class_6910)holder.comp_349()).method_40469((class_6910.class_6915)helper).method_40464((class_6910.class_6912)new class_6910.class_6914(pos.method_10263(), pos.method_10264(), pos.method_10260()));
        return (double)Math.round(d * 1000.0) / 1000.0;
    }

    private static class_2561 getRegion(double erosion, double regionSelector) {
        String nameText;
        String iconText;
        if (erosion < 0.0) {
            if (regionSelector < 0.0) {
                iconText = "\u2663";
                nameText = "Club";
            } else {
                iconText = "\u2665";
                nameText = "Heart";
            }
        } else if (regionSelector < 0.0) {
            iconText = "\u2660";
            nameText = "Spade";
        } else {
            iconText = "\u2666";
            nameText = "Diamond";
        }
        class_5250 icon = class_2561.method_43470((String)iconText);
        icon.method_27692(regionSelector < 0.0 ? class_124.field_1063 : class_124.field_1061);
        class_5250 name = class_2561.method_43470((String)nameText);
        return class_2561.method_48322((String)"command.tectonic.region", (String)"Region: %s %s (Erosion %s / Region Selector %s)", (Object[])new Object[]{icon, name, erosion, regionSelector});
    }

    private static class_5321<class_6910> key(String name) {
        return class_5321.method_29179((class_5321)class_7924.field_41240, (class_2960)Tectonic.id(name));
    }

    private static interface LocateTargets {
        public static final Map<String, class_6497<Double>> UNDERGROUND_RIVER = Map.of("noise/continent/ridges_folded", LocateTargets.range(0.0, 0.025), "noise/raw_continents", LocateTargets.range(-0.1, 64.0), "noise/continent/erosion_folded", LocateTargets.range(0.0, 0.225));
        public static final Map<String, class_6497<Double>> MOUNTAIN_RANGE = Map.of("noise/continent/erosion_folded", LocateTargets.range(0.0, 0.05), "noise/raw_continents", LocateTargets.range(0.1, 64.0));
        public static final Map<String, class_6497<Double>> JUNGLE_PILLARS = Map.of("noise/continent/ridges", LocateTargets.range(-0.75, -0.2), "noise/vegetation_index", LocateTargets.range(4.0, 5.0), "noise/temperature_index", LocateTargets.range(4.0, 4.0), "noise/region_selector", LocateTargets.range(0.1, 64.0), "noise/continent/erosion", LocateTargets.range(-0.8, -0.45), "noise/raw_continents", LocateTargets.range(0.1, 64.0));
        public static final Map<String, class_6497<Double>> ROLLING_HILLS = Map.of("noise/continent/ridges_folded", LocateTargets.range(0.2, 64.0), "noise/vegetation_index", LocateTargets.range(0.0, 2.0), "noise/temperature_index", LocateTargets.range(0.0, 3.0), "noise/region_selector", LocateTargets.range(0.1, 64.0), "noise/continent/erosion", LocateTargets.range(-0.8, -0.45), "noise/raw_continents", LocateTargets.range(0.1, 64.0));
        public static final Map<String, class_6497<Double>> BADLANDS_CANYON = Map.of("noise/continent/ridges_folded", LocateTargets.range(0.2, 64.0), "noise/temperature_index", LocateTargets.range(5.0, 5.0), "noise/region_selector", LocateTargets.range(-64.0, 0.0), "noise/continent/erosion", LocateTargets.range(0.45, 0.8), "noise/raw_continents", LocateTargets.range(0.35, 64.0));
        public static final Map<String, class_6497<Double>> BADLANDS_PLATEAUS = Map.of("noise/continent/ridges_folded", LocateTargets.range(0.2, 64.0), "noise/temperature_index", LocateTargets.range(5.0, 5.0), "noise/region_selector", LocateTargets.range(-64.0, 0.0), "noise/continent/erosion", LocateTargets.range(-8.0, -0.45), "noise/raw_continents", LocateTargets.range(0.35, 64.0));
        public static final Map<String, class_6497<Double>> DESERT_DUNES = Map.of("noise/continent/ridges_folded", LocateTargets.range(0.2, 64.0), "noise/temperature_index", LocateTargets.range(5.0, 5.0), "noise/region_selector", LocateTargets.range(0.1, 64.0), "noise/continent/erosion", LocateTargets.range(0.45, 0.8), "noise/raw_continents", LocateTargets.range(0.1, 64.0));
        public static final Map<String, class_6497<Double>> CHERRY_VALLEY = Map.of("noise/continent/ridges_folded", LocateTargets.range(0.4, 64.0), "noise/vegetation_index", LocateTargets.range(0.0, 2.0), "noise/temperature_index", LocateTargets.range(3.0, 3.0), "noise/region_selector", LocateTargets.range(-64.0, 0.0), "noise/continent/erosion", LocateTargets.range(-0.8, -0.45), "noise/raw_continents", LocateTargets.range(0.35, 64.0));

        private static class_6497<Double> range(double min, double max) {
            return new class_6497((Comparable)Double.valueOf(min), (Comparable)Double.valueOf(max));
        }
    }
}

