/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.tectonic.worldgen.densityfunction;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.tectonic.config.ConfigHandler;
import java.util.Arrays;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public record ConfigConstant(double value, double min, double max) implements DensityFunction
{
    public static MapCodec<ConfigConstant> DATA_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("key").forGetter(df -> ""), (App)Codec.BOOL.fieldOf("min_max_hack").orElse((Object)false).forGetter(df -> df.min == Double.NEGATIVE_INFINITY)).apply((Applicative)instance, ConfigConstant::create));
    public static KeyDispatchDataCodec<ConfigConstant> CODEC_HOLDER = KeyDispatchDataCodec.of(DATA_CODEC);

    public static ConfigConstant create(String key, boolean minMaxHack) {
        double value = ConfigHandler.getState().getValue(key);
        return new ConfigConstant(value, minMaxHack ? Double.NEGATIVE_INFINITY : value, minMaxHack ? Double.POSITIVE_INFINITY : value);
    }

    public double compute(DensityFunction.FunctionContext context) {
        return this.value;
    }

    public void fillArray(double[] doubles, DensityFunction.ContextProvider contextProvider) {
        Arrays.fill(doubles, this.value);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)this);
    }

    public double minValue() {
        return this.min;
    }

    public double maxValue() {
        return this.max;
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC_HOLDER;
    }
}

