/*
 * Decompiled with CFR 0.152.
 */
package com.lithiumcraft.dimension_expansion.datagen;

import com.lithiumcraft.dimension_expansion.datagen.ModBlockLootTableProvider;
import com.lithiumcraft.dimension_expansion.datagen.ModBlockStateProvider;
import com.lithiumcraft.dimension_expansion.datagen.ModBlockTagProvider;
import com.lithiumcraft.dimension_expansion.datagen.ModDamageTypeTagProvider;
import com.lithiumcraft.dimension_expansion.datagen.ModItemModelProvider;
import com.lithiumcraft.dimension_expansion.datagen.ModLangProvider;
import com.lithiumcraft.dimension_expansion.datagen.ModRecipeProvider;
import com.lithiumcraft.dimension_expansion.datagen.ModRegistriesProvider;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="dimension_expansion")
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        if (event.includeClient()) {
            generator.addProvider(true, (DataProvider)new ModBlockStateProvider(packOutput, existingFileHelper));
            generator.addProvider(true, (DataProvider)new ModItemModelProvider(packOutput, existingFileHelper));
            generator.addProvider(true, (DataProvider)new ModLangProvider(packOutput));
        }
        if (event.includeServer()) {
            ModRegistriesProvider datapackProvider = new ModRegistriesProvider(packOutput, event.getLookupProvider());
            CompletableFuture lookupProvider = datapackProvider.getRegistryProvider();
            generator.addProvider(true, (DataProvider)datapackProvider);
            generator.addProvider(true, (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(ModBlockLootTableProvider::new, LootContextParamSets.BLOCK)), lookupProvider));
            generator.addProvider(true, (DataProvider)new ModRecipeProvider(packOutput, lookupProvider));
            ModBlockTagProvider blockTagsProvider = new ModBlockTagProvider(packOutput, lookupProvider, existingFileHelper);
            generator.addProvider(true, (DataProvider)blockTagsProvider);
            ModDamageTypeTagProvider modDamageTypeTagsProvider = new ModDamageTypeTagProvider(packOutput, lookupProvider, existingFileHelper);
            generator.addProvider(true, (DataProvider)modDamageTypeTagsProvider);
        }
    }
}

