/*
 * Decompiled with CFR 0.152.
 */
package com.lithiumcraft.dimension_expansion.datagen;

import com.lithiumcraft.dimension_expansion.block.ModBlocks;
import com.lithiumcraft.dimension_expansion.item.ModItems;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;

public class ModRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public ModRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.BLANK_TELEPORTER.get())).pattern("DCD").pattern("SNH").pattern("DCD").define(Character.valueOf('C'), (ItemLike)Items.CALIBRATED_SCULK_SENSOR).define(Character.valueOf('S'), (ItemLike)Items.SCULK_CATALYST).define(Character.valueOf('H'), (ItemLike)Items.SCULK_SHRIEKER).define(Character.valueOf('N'), (ItemLike)Items.NETHERITE_PICKAXE).define(Character.valueOf('D'), (ItemLike)Items.CHISELED_DEEPSLATE).unlockedBy("has_dead_bush", ModRecipeProvider.has((ItemLike)Items.DEAD_BUSH)).save(recipeOutput, ModRecipeProvider.modLoc("blocks/blank_teleporter"));
        this.smithingTransformRecipe(recipeOutput, "deep_beneath_teleporter", (ItemLike)ModItems.DEEP_BENEATH_TELEPORTER_ITEM.get(), (ItemLike)ModItems.ENDER_GEM, (ItemLike)ModItems.BLANK_TELEPORTER.get(), (ItemLike)Items.DEEPSLATE_DIAMOND_ORE);
        this.smithingTransformRecipe(recipeOutput, "mining_teleporter", (ItemLike)ModItems.MINING_TELEPORTER_ITEM.get(), (ItemLike)ModItems.ENDER_GEM, (ItemLike)ModItems.BLANK_TELEPORTER.get(), (ItemLike)Items.DIAMOND_ORE);
        this.smithingTransformRecipe(recipeOutput, "stone_block_teleporter", (ItemLike)ModItems.STONE_BLOCK_TELEPORTER_ITEM.get(), (ItemLike)ModItems.ENDER_GEM, (ItemLike)ModItems.BLANK_TELEPORTER.get(), (ItemLike)Items.EMERALD_ORE);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.ENDER_CRYSTAL.get())).requires((ItemLike)ModItems.ENDER_CRYSTAL_SHARD.get(), 4).unlockedBy("has_ender_crystal_shard", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.ENDER_CRYSTAL_SHARD.get()))).save(recipeOutput, ModRecipeProvider.modLoc("items/ender_crystal"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.ENDER_CREAM.get())).requires((ItemLike)Items.ENDER_EYE).requires((ItemLike)Items.SLIME_BALL).requires((ItemLike)Items.MAGMA_CREAM).unlockedBy("has_ender_eye", ModRecipeProvider.has((ItemLike)Items.ENDER_EYE)).unlockedBy("has_slime_ball", ModRecipeProvider.has((ItemLike)Items.SLIME_BALL)).unlockedBy("has_magma_cream", ModRecipeProvider.has((ItemLike)Items.MAGMA_CREAM)).save(recipeOutput, ModRecipeProvider.modLoc("items/ender_cream"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.ENDER_GEM.get())).pattern("CCC").pattern("CEC").pattern("CCC").define(Character.valueOf('C'), (ItemLike)ModItems.ENDER_CRYSTAL.get()).define(Character.valueOf('E'), (ItemLike)Items.EMERALD_BLOCK).unlockedBy("has_ender_crystal", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.ENDER_CRYSTAL.get()))).unlockedBy("has_emerald_block", ModRecipeProvider.has((ItemLike)Items.EMERALD_BLOCK)).save(recipeOutput, ModRecipeProvider.modLoc("items/ender_gem"));
        this.smeltingRecipe(recipeOutput, "ender_crystal_shard", (ItemLike)ModItems.ENDER_CREAM.get(), (ItemLike)ModItems.ENDER_CRYSTAL_SHARD, 0.1f, 200);
        this.smeltingRecipe(recipeOutput, "quartz_from_quartz_ore", (ItemLike)ModBlocks.QUARTZ_ORE.get(), (ItemLike)Items.QUARTZ, 0.2f, 200);
        this.smeltingRecipe(recipeOutput, "quartz_from_deepslate_quartz_ore", (ItemLike)ModBlocks.DEEPSLATE_QUARTZ_ORE.get(), (ItemLike)Items.QUARTZ, 0.2f, 200);
    }

    private static ResourceLocation modLoc(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"dimension_expansion", (String)path);
    }

    private void smeltingRecipe(RecipeOutput recipeOutput, String name, ItemLike input, ItemLike result, float xp, int time) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input.asItem()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (float)xp, (int)time).unlockedBy(ModRecipeProvider.getHasName((ItemLike)input), ModRecipeProvider.has((ItemLike)input)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"dimension_expansion", (String)("smelting/" + name)));
    }

    private void blastingRecipe(RecipeOutput recipeOutput, String name, ItemLike input, ItemLike result, float xp, int time) {
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input.asItem()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (float)xp, (int)time).unlockedBy(ModRecipeProvider.getHasName((ItemLike)input), ModRecipeProvider.has((ItemLike)input)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"dimension_expansion", (String)("blasting/" + name)));
    }

    private void smokingRecipe(RecipeOutput recipeOutput, String name, ItemLike input, ItemLike result, float xp, int time) {
        SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input.asItem()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (float)xp, (int)time).unlockedBy(ModRecipeProvider.getHasName((ItemLike)input), ModRecipeProvider.has((ItemLike)input)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"dimension_expansion", (String)("smoking/" + name)));
    }

    private void campfireCookingRecipe(RecipeOutput recipeOutput, String name, ItemLike input, ItemLike result, float xp, int time) {
        SimpleCookingRecipeBuilder.campfireCooking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input.asItem()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (float)xp, (int)time).unlockedBy(ModRecipeProvider.getHasName((ItemLike)input), ModRecipeProvider.has((ItemLike)input)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"dimension_expansion", (String)("campfire/" + name)));
    }

    private void stonecuttingRecipe(RecipeOutput recipeOutput, String name, ItemLike input, ItemLike result, int count) {
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input.asItem()}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).unlockedBy(ModRecipeProvider.getHasName((ItemLike)input), ModRecipeProvider.has((ItemLike)input)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"dimension_expansion", (String)("stonecutting/" + name)));
    }

    private void smithingTransformRecipe(RecipeOutput recipeOutput, String name, ItemLike output, ItemLike template, ItemLike base, ItemLike addition) {
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{template.asItem()}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{base.asItem()}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{addition.asItem()}), (RecipeCategory)RecipeCategory.MISC, (Item)output.asItem()).unlocks(ModRecipeProvider.getHasName((ItemLike)base), ModRecipeProvider.has((ItemLike)base)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"dimension_expansion", (String)("smithing/" + name)));
    }

    private void stonecuttingRecipe(RecipeOutput recipeOutput, String name, String tagNamespace, String tagPath, ItemLike result, int count, String unlockName) {
        TagKey tag = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)tagNamespace, (String)tagPath));
        Ingredient ingredient = Ingredient.of((TagKey)tag);
        SingleItemRecipeBuilder.stonecutting((Ingredient)ingredient, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).unlockedBy("has_" + unlockName, ModRecipeProvider.has((TagKey)tag)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"dimension_expansion", (String)("stonecutting/" + name)));
    }
}

