/*
 * Decompiled with CFR 0.152.
 */
package com.lithiumcraft.dimension_expansion.mixin;

import com.lithiumcraft.dimension_expansion.util.SpawnContextHolder;
import com.lithiumcraft.dimension_expansion.worldgen.DimensionExpansionDimensions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NaturalSpawner;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={NaturalSpawner.SpawnState.class})
public abstract class SpawnStateMixin {
    private static final int AREA = 289;

    @Inject(method={"canSpawnForCategory(Lnet/minecraft/world/entity/MobCategory;Lnet/minecraft/world/level/ChunkPos;)Z"}, at={@At(value="RETURN")}, cancellable=true)
    private void doubleCap(MobCategory category, ChunkPos pos, CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)cir.getReturnValue()).booleanValue()) {
            return;
        }
        if (category != MobCategory.MONSTER) {
            return;
        }
        ServerLevel level = SpawnContextHolder.get();
        if (level == null || !level.dimension().equals(DimensionExpansionDimensions.DEEP_BENEATH)) {
            return;
        }
        NaturalSpawner.SpawnState self = (NaturalSpawner.SpawnState)this;
        int current = self.getMobCategoryCounts().getInt((Object)category);
        int spawnable = self.getSpawnableChunkCount();
        int baseCap = category.getMaxInstancesPerChunk() * spawnable / 289;
        int doubledCap = Math.max(1, baseCap * 2);
        if (current < doubledCap) {
            cir.setReturnValue((Object)true);
        }
    }
}

