/*
 * Decompiled with CFR 0.152.
 */
package com.lithiumcraft.dimension_expansion.structure;

import com.lithiumcraft.dimension_expansion.block.ModBlocks;
import com.lithiumcraft.dimension_expansion.block.OverworldReturnTeleporterBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class StructureBuilder {
    public static void buildDeepBeneathPlatform(ServerLevel level, BlockPos center) {
        int dz;
        int dx;
        BlockState cobble = Blocks.COBBLESTONE.defaultBlockState();
        BlockState teleporter = ((OverworldReturnTeleporterBlock)((Object)ModBlocks.OVERWORLD_RETURN_TELEPORTER.get())).defaultBlockState();
        for (dx = -2; dx <= 2; ++dx) {
            for (dz = -2; dz <= 2; ++dz) {
                for (int dy = 0; dy <= 3; ++dy) {
                    BlockPos target = center.offset(dx, dy, dz);
                    BlockState state = level.getBlockState(target);
                    level.setBlockAndUpdate(target, Blocks.AIR.defaultBlockState());
                }
            }
        }
        for (dx = -2; dx <= 2; ++dx) {
            for (dz = -2; dz <= 2; ++dz) {
                BlockPos pos = center.offset(dx, 0, dz);
                level.setBlockAndUpdate(pos, cobble);
            }
        }
        level.setBlockAndUpdate(center.above(), teleporter);
    }

    public static void buildStoneBlockPlatform(ServerLevel level, BlockPos center) {
        int dz;
        int dx;
        BlockState cobble = Blocks.STONE.defaultBlockState();
        BlockState teleporter = ((OverworldReturnTeleporterBlock)((Object)ModBlocks.OVERWORLD_RETURN_TELEPORTER.get())).defaultBlockState();
        for (dx = -2; dx <= 2; ++dx) {
            for (dz = -2; dz <= 2; ++dz) {
                for (int dy = 0; dy <= 3; ++dy) {
                    BlockPos target = center.offset(dx, dy, dz);
                    BlockState state = level.getBlockState(target);
                    level.setBlockAndUpdate(target, Blocks.AIR.defaultBlockState());
                }
            }
        }
        for (dx = -2; dx <= 2; ++dx) {
            for (dz = -2; dz <= 2; ++dz) {
                BlockPos pos = center.offset(dx, 0, dz);
                level.setBlockAndUpdate(pos, cobble);
            }
        }
        level.setBlockAndUpdate(center.above(), teleporter);
    }

    public static void buildMiningPlatform(ServerLevel level, BlockPos center) {
        BlockPos teleporterPos = center;
        BlockState teleporter = ((OverworldReturnTeleporterBlock)((Object)ModBlocks.OVERWORLD_RETURN_TELEPORTER.get())).defaultBlockState();
        level.setBlockAndUpdate(teleporterPos, teleporter);
    }
}

