/*
 * Decompiled with CFR 0.152.
 */
package com.lithiumcraft.dimension_expansion.worldgen.feature;

import com.lithiumcraft.dimension_expansion.worldgen.feature.config.CobbleSpikesConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class CobbleSpikesFeature
extends Feature<CobbleSpikesConfig> {
    private static final BlockState COBBLE = Blocks.COBBLESTONE.defaultBlockState();
    private static final int CEILING_SKIP_OUT_OF_256 = 20;

    public CobbleSpikesFeature() {
        super(CobbleSpikesConfig.CODEC);
    }

    public boolean place(FeaturePlaceContext<CobbleSpikesConfig> ctx) {
        WorldGenLevel level = ctx.level();
        CobbleSpikesConfig cfg = (CobbleSpikesConfig)ctx.config();
        RandomSource rng = ctx.random();
        ChunkPos chunk = new ChunkPos(ctx.origin());
        int minX = chunk.getMinBlockX();
        int maxX = chunk.getMaxBlockX();
        int minZ = chunk.getMinBlockZ();
        int maxZ = chunk.getMaxBlockZ();
        boolean placed = false;
        int tf = Math.max(2, cfg.floorTile());
        int tx0 = Math.floorDiv(minX, tf);
        int tx1 = Math.floorDiv(maxX, tf);
        int tz0 = Math.floorDiv(minZ, tf);
        int tz1 = Math.floorDiv(maxZ, tf);
        for (int tx = tx0; tx <= tx1; ++tx) {
            for (int tz = tz0; tz <= tz1; ++tz) {
                Integer y;
                long h = Mth.getSeed((int)tx, (int)0, (int)tz) ^ level.getSeed();
                int pick = (int)Math.floorMod(h, (long)tf * (long)tf);
                int ox = pick % tf;
                int oz = pick / tf;
                int x = tx * tf + ox;
                int z = tz * tf + oz;
                if (x < minX || x > maxX || z < minZ || z > maxZ || (y = this.findFloor(level, x, z, cfg.yMin(), cfg.yMax())) == null) continue;
                int height = cfg.floorHeight().sample(rng);
                int rBase = cfg.floorRadius().sample(rng);
                if (y - cfg.yMin() <= 1 && height < 2) {
                    ++height;
                }
                placed |= this.placeFloorBlob(level, x, y, z, rBase, height, minX, maxX, minZ, maxZ);
            }
        }
        int tc = Math.max(1, cfg.ceilingTile());
        int cx0 = Math.floorDiv(minX, tc);
        int cx1 = Math.floorDiv(maxX, tc);
        int cz0 = Math.floorDiv(minZ, tc);
        int cz1 = Math.floorDiv(maxZ, tc);
        for (int tx = cx0; tx <= cx1; ++tx) {
            for (int tz = cz0; tz <= cz1; ++tz) {
                Integer y;
                long h = Mth.getSeed((int)tx, (int)0, (int)tz) ^ (level.getSeed() ^ 0xFFFFFFFFFFFFFFFFL);
                int pick = (int)Math.floorMod(h, (long)tc * (long)tc);
                int ox = pick % tc;
                int oz = pick / tc;
                int x = tx * tc + ox;
                int z = tz * tc + oz;
                if (x < minX || x > maxX || z < minZ || z > maxZ || (Mth.getSeed((int)x, (int)0, (int)z) & 0xFFL) < 20L || (y = this.findCeiling(level, x, z, cfg.yMin(), cfg.yMax())) == null) continue;
                int len = cfg.ceilingHeight().sample(rng);
                if (cfg.yMax() - y <= 1 && len < 8) {
                    len += 2;
                }
                placed |= this.growDown(level, x, y, z, len, cfg.yMin());
            }
        }
        return placed;
    }

    private boolean placeFloorBlob(WorldGenLevel level, int cx, int y, int cz, int rBase, int height, int minX, int maxX, int minZ, int maxZ) {
        BlockPos p;
        boolean any = false;
        rBase = Math.max(1, Math.min(rBase, 3));
        height = Math.max(1, Math.min(height, 3));
        any |= this.fillBlobLayer(level, cx, y, cz, rBase, minX, maxX, minZ, maxZ, true);
        int yTop = y;
        int r = rBase - 1;
        for (int i = 1; i < height && r >= 1; --r, ++i) {
            int yy = y + i;
            any |= this.fillBlobLayer(level, cx, yy, cz, r, minX, maxX, minZ, maxZ, true);
            yTop = yy;
        }
        for (int yy = yTop + 1; yy < y + height && level.isEmptyBlock(p = new BlockPos(cx, yy, cz)); ++yy) {
            level.setBlock(p, COBBLE, 2);
            any = true;
        }
        return any;
    }

    private boolean fillBlobLayer(WorldGenLevel level, int cx, int y, int cz, int r, int minX, int maxX, int minZ, int maxZ, boolean raggedEdge) {
        boolean any = false;
        int r2 = r * r;
        for (int dz = -r; dz <= r; ++dz) {
            for (int dx = -r; dx <= r; ++dx) {
                BlockPos p;
                long h;
                int d2;
                int x = cx + dx;
                int z = cz + dz;
                if (x < minX || x > maxX || z < minZ || z > maxZ || (d2 = dx * dx + dz * dz) > r2 || raggedEdge && d2 > (r - 1) * (r - 1) && ((h = Mth.getSeed((int)x, (int)y, (int)z) ^ 0xC3A5C85C97CB3127L) & 0xFFL) < 102L || !level.isEmptyBlock(p = new BlockPos(x, y, z))) continue;
                level.setBlock(p, COBBLE, 2);
                any = true;
            }
        }
        return any;
    }

    private boolean growDown(WorldGenLevel level, int x, int yStart, int z, int len, int yMin) {
        BlockPos p;
        boolean any = false;
        for (int i = 0; i < len && yStart - i >= yMin && level.isEmptyBlock(p = new BlockPos(x, yStart - i, z)); ++i) {
            level.setBlock(p, COBBLE, 2);
            any = true;
        }
        return any;
    }

    private Integer findFloor(WorldGenLevel level, int x, int z, int yMin, int yMax) {
        for (int y = yMin; y < yMax; ++y) {
            BlockPos below;
            BlockPos p = new BlockPos(x, y, z);
            if (!level.isEmptyBlock(p) || level.isEmptyBlock(below = p.below()) || !level.getBlockState(below).isFaceSturdy((BlockGetter)level, below, Direction.UP)) continue;
            return y;
        }
        return null;
    }

    private Integer findCeiling(WorldGenLevel level, int x, int z, int yMin, int yMax) {
        for (int y = yMax - 1; y >= yMin; --y) {
            BlockPos above;
            BlockPos p = new BlockPos(x, y, z);
            if (!level.isEmptyBlock(p) || level.isEmptyBlock(above = p.above()) || !level.getBlockState(above).isFaceSturdy((BlockGetter)level, above, Direction.DOWN)) continue;
            return y;
        }
        return null;
    }
}

