/*
 * Decompiled with CFR 0.152.
 */
package com.lithiumcraft.dimension_expansion.worldgen.spawn;

import com.lithiumcraft.dimension_expansion.Config;
import com.lithiumcraft.dimension_expansion.DimensionExpansion;
import com.lithiumcraft.dimension_expansion.worldgen.DimensionExpansionDimensions;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.event.entity.living.MobSpawnEvent;

public class MobSpawnRules {
    private static final Set<EntityType<?>> EXTRA_CREATURES = Set.of(EntityType.POLAR_BEAR);

    public static void onSpawnPlacementCheck(MobSpawnEvent.SpawnPlacementCheck event) {
        ServerLevelAccessor level = event.getLevel();
        EntityType type = event.getEntityType();
        BlockPos pos = event.getPos();
        RandomSource random = event.getRandom();
        if (!level.getLevel().dimension().equals(DimensionExpansionDimensions.DEEP_BENEATH)) {
            return;
        }
        if (level.getDifficulty() == Difficulty.PEACEFUL) {
            event.setResult(MobSpawnEvent.SpawnPlacementCheck.Result.FAIL);
            return;
        }
        if (type.getCategory() == MobCategory.MONSTER || EXTRA_CREATURES.contains(type)) {
            if (type == EntityType.SLIME) {
                if (level.getBlockState(pos.below()).isValidSpawn((BlockGetter)level, pos.below(), type)) {
                    MobSpawnRules.logDebug("Deep Beneath slime spawn", type, pos, level);
                    event.setResult(MobSpawnEvent.SpawnPlacementCheck.Result.SUCCEED);
                } else {
                    event.setResult(MobSpawnEvent.SpawnPlacementCheck.Result.FAIL);
                }
                return;
            }
            if (level.getBlockState(pos.below()).isValidSpawn((BlockGetter)level, pos.below(), type)) {
                MobSpawnRules.logDebug("Deep Beneath spawn", type, pos, level);
                event.setResult(MobSpawnEvent.SpawnPlacementCheck.Result.SUCCEED);
            } else {
                event.setResult(MobSpawnEvent.SpawnPlacementCheck.Result.FAIL);
            }
        }
    }

    private static void logDebug(String prefix, EntityType<?> type, BlockPos pos, ServerLevelAccessor level) {
        if (Config.debugEnabled) {
            DimensionExpansion.LOGGER.debug("{}: {} at {} blockLight={} skyLight={}", new Object[]{prefix, type.getDescriptionId(), pos, level.getBrightness(LightLayer.BLOCK, pos), level.getBrightness(LightLayer.SKY, pos)});
        }
    }
}

