/*
 * Decompiled with CFR 0.152.
 */
package com.lithiumcraft.dimension_expansion.effect;

import com.lithiumcraft.dimension_expansion.registry.ModEffects;
import com.lithiumcraft.dimension_expansion.registry.ModSounds;
import java.util.Random;
import java.util.WeakHashMap;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class NightWalkerEffect
extends MobEffect {
    private static final int DAMAGE_INTERVAL_TICKS_MIN = 100;
    private static final int DAMAGE_INTERVAL_TICKS_MAX = 400;
    private static final Random RANDOM = new Random();
    private static final WeakHashMap<Player, Integer> nextDamageTick = new WeakHashMap();

    public NightWalkerEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        ResourceKey resistanceKey;
        ServerPlayer player;
        block8: {
            block7: {
                if (!(entity instanceof ServerPlayer)) break block7;
                player = (ServerPlayer)entity;
                if (!entity.level().isClientSide() && !player.isCreative() && !player.isSpectator()) break block8;
            }
            return false;
        }
        Registry mobEffectRegistry = player.level().registryAccess().registryOrThrow(Registries.MOB_EFFECT);
        Holder.Reference resistanceHolder = mobEffectRegistry.getHolderOrThrow(resistanceKey = ResourceKey.create((ResourceKey)Registries.MOB_EFFECT, (ResourceLocation)ModEffects.NIGHTWALKER_RESISTANCE.getId()));
        if (player.hasEffect((Holder)resistanceHolder) || player.getHealth() <= 1.0f) {
            nextDamageTick.remove(player);
            return false;
        }
        int currentTick = player.tickCount;
        int next = nextDamageTick.getOrDefault(player, -1);
        if (next == -1 || currentTick >= next) {
            float current = player.getHealth();
            if (current > 1.0f) {
                player.setHealth(current - 1.0f);
            }
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), ModSounds.NIGHTWALKER_DAMAGE.get(), player.getSoundSource(), 1.0f, 1.0f);
            if (!player.hasEffect(MobEffects.DARKNESS)) {
                player.addEffect(new MobEffectInstance(MobEffects.DARKNESS, 50, 0, false, false, false));
            }
            int delay = RANDOM.nextInt(301) + 100;
            nextDamageTick.put((Player)player, currentTick + delay);
        }
        return true;
    }
}

