/*
 * Decompiled with CFR 0.152.
 */
package com.lithiumcraft.dimension_expansion.worldgen.feature;

import com.lithiumcraft.dimension_expansion.worldgen.feature.config.CobbleSpireConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class CobbleSpireFeature
extends Feature<CobbleSpireConfig> {
    private static final BlockState COBBLE = Blocks.COBBLESTONE.defaultBlockState();

    public CobbleSpireFeature() {
        super(CobbleSpireConfig.CODEC);
    }

    public boolean place(FeaturePlaceContext<CobbleSpireConfig> ctx) {
        int baseR;
        WorldGenLevel level = ctx.level();
        RandomSource rng = ctx.random();
        CobbleSpireConfig cfg = (CobbleSpireConfig)ctx.config();
        int safety = baseR = Mth.clamp((int)cfg.radius().sample(rng), (int)2, (int)6);
        BlockPos origin = ctx.origin();
        ChunkPos chunk = new ChunkPos(origin);
        int minX = chunk.getMinBlockX();
        int maxX = chunk.getMaxBlockX();
        int minZ = chunk.getMinBlockZ();
        int maxZ = chunk.getMaxBlockZ();
        int cx = Mth.clamp((int)origin.getX(), (int)(minX + safety), (int)(maxX - safety));
        int cz = Mth.clamp((int)origin.getZ(), (int)(minZ + safety), (int)(maxZ - safety));
        Integer floorY = this.findFloor(level, cx, cz, cfg.yMin(), cfg.yMax());
        Integer ceilY = this.findCeiling(level, cx, cz, cfg.yMin(), cfg.yMax());
        if (floorY == null || ceilY == null || ceilY <= floorY + 2) {
            return false;
        }
        boolean placed = false;
        if (floorY - 1 >= level.getMinBuildHeight()) {
            placed |= this.placeLayer(level, cx, floorY - 1, cz, baseR, baseR, true, minX, maxX, minZ, maxZ);
        }
        if (ceilY + 1 < level.getMaxBuildHeight()) {
            placed |= this.placeLayer(level, cx, ceilY + 1, cz, baseR, baseR, true, minX, maxX, minZ, maxZ);
        }
        for (int y = floorY.intValue(); y <= ceilY; ++y) {
            int m = Math.min(y - floorY, ceilY - y);
            int thickBoost = m < 9 ? (int)Math.ceil(Math.sqrt(9 - m)) : 0;
            int rHard = Math.max(1, baseR - 1 + thickBoost);
            int rSoft = Math.max(rHard, baseR + thickBoost);
            if (rng.nextFloat() < 0.15f) {
                rHard = Mth.clamp((int)(rHard + (rng.nextBoolean() ? 1 : -1)), (int)1, (int)7);
            }
            rSoft = Math.min(Math.max(rSoft, rHard), 7);
            placed |= this.placeLayer(level, cx, y, cz, rHard, rSoft, false, minX, maxX, minZ, maxZ);
        }
        return placed;
    }

    private Integer findFloor(WorldGenLevel level, int x, int z, int yMin, int yMax) {
        for (int y = yMin; y < yMax; ++y) {
            BlockPos below;
            BlockPos p = new BlockPos(x, y, z);
            if (!level.isEmptyBlock(p) || level.isEmptyBlock(below = p.below()) || !level.getBlockState(below).isFaceSturdy((BlockGetter)level, below, Direction.UP)) continue;
            return y;
        }
        return null;
    }

    private Integer findCeiling(WorldGenLevel level, int x, int z, int yMin, int yMax) {
        for (int y = yMax - 1; y >= yMin; --y) {
            BlockPos above;
            BlockPos p = new BlockPos(x, y, z);
            if (!level.isEmptyBlock(p) || level.isEmptyBlock(above = p.above()) || !level.getBlockState(above).isFaceSturdy((BlockGetter)level, above, Direction.DOWN)) continue;
            return y;
        }
        return null;
    }

    private boolean placeLayer(WorldGenLevel level, int cx, int y, int cz, int rHard, int rSoft, boolean overwriteSolid, int minX, int maxX, int minZ, int maxZ) {
        boolean any = false;
        int hard2 = rHard * rHard;
        int soft2 = rSoft * rSoft;
        for (int dz = -rSoft; dz <= rSoft; ++dz) {
            for (int dx = -rSoft; dx <= rSoft; ++dx) {
                int d2 = dx * dx + dz * dz;
                if (d2 > soft2) continue;
                int x = cx + dx;
                int z = cz + dz;
                if (x < minX || x > maxX || z < minZ || z > maxZ) continue;
                BlockPos p = new BlockPos(x, y, z);
                if (d2 <= hard2) {
                    if (!overwriteSolid && !level.isEmptyBlock(p)) continue;
                    level.setBlock(p, COBBLE, 2);
                    any = true;
                    continue;
                }
                if ((Mth.getSeed((int)x, (int)y, (int)z) >>> 1 & 1L) != 0L || !overwriteSolid && !level.isEmptyBlock(p)) continue;
                level.setBlock(p, COBBLE, 2);
                any = true;
            }
        }
        return any;
    }
}

