/*
 * Decompiled with CFR 0.152.
 */
package com.lithiumcraft.dimension_expansion.event;

import com.lithiumcraft.dimension_expansion.registry.ModDamageTypes;
import com.lithiumcraft.dimension_expansion.registry.ModEffects;
import com.lithiumcraft.dimension_expansion.registry.ModSounds;
import com.lithiumcraft.dimension_expansion.worldgen.DimensionExpansionDimensions;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

@EventBusSubscriber(modid="dimension_expansion")
public class DeepBeneathDarknessDamageHandler {
    private static final WeakHashMap<ServerPlayer, Integer> darkTimers = new WeakHashMap();
    private static final WeakHashMap<ServerPlayer, Integer> deathTimers = new WeakHashMap();
    private static final int DARKNESS_THRESHOLD_TICKS = 100;
    private static final int DEATH_THRESHOLD_TICKS = 1200;
    private static final int WARNING_START_TICKS = 600;
    private static final int DECAY_RATE = 5;

    @SubscribeEvent
    public static void onLevelTick(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        for (ServerPlayer player : level2.players()) {
            if (!level2.dimension().equals(DimensionExpansionDimensions.DEEP_BENEATH)) {
                player.removeEffect(ModEffects.NIGHTWALKER);
                darkTimers.remove(player);
                deathTimers.remove(player);
                continue;
            }
            if (player.isCreative() || player.isSpectator()) continue;
            BlockPos pos = player.blockPosition();
            int blockLight = level2.getBrightness(LightLayer.BLOCK, pos);
            int darkTimer = darkTimers.getOrDefault(player, 0);
            int deathTimer = deathTimers.getOrDefault(player, 0);
            if (blockLight == 0) {
                ResourceKey key;
                Registry registry;
                Holder.Reference nightWalker;
                if (darkTimer == 0) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.dimension_expansion.nightwalker_warning"), false);
                }
                ++deathTimer;
                if (++darkTimer >= 100 && !player.hasEffect((Holder)(nightWalker = (registry = level2.registryAccess().registryOrThrow(Registries.MOB_EFFECT)).getHolderOrThrow(key = ResourceKey.create((ResourceKey)Registries.MOB_EFFECT, (ResourceLocation)ModEffects.NIGHTWALKER.getId()))))) {
                    player.addEffect(new MobEffectInstance((Holder)nightWalker, 200, 0, false, false, false));
                }
                if (deathTimer == 600) {
                    level2.playSound(null, player.blockPosition(), ModSounds.DARKNESS_APPROACHES.get(), player.getSoundSource(), 1.0f, 1.0f);
                }
                if (deathTimer == 800) {
                    player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 500, 0, false, false, false));
                }
                if (deathTimer >= 1200) {
                    Holder.Reference type = level2.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(ModDamageTypes.DARKNESS);
                    player.hurt(new DamageSource((Holder)type), Float.MAX_VALUE);
                }
            } else if (blockLight > 1) {
                darkTimer = 0;
                deathTimer = 0;
            } else if (darkTimer > 0) {
                darkTimer = Math.max(0, darkTimer - 5);
            }
            if (darkTimer > 0) {
                darkTimers.put(player, darkTimer);
            } else {
                darkTimers.remove(player);
            }
            if (deathTimer > 0) {
                deathTimers.put(player, deathTimer);
                continue;
            }
            deathTimers.remove(player);
        }
    }
}

