/*
 * Decompiled with CFR 0.152.
 */
package com.lithiumcraft.dimension_expansion.event;

import com.lithiumcraft.dimension_expansion.worldgen.DimensionExpansionDimensions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;

@EventBusSubscriber(modid="dimension_expansion")
public class DeepBeneathMobBuffHandler {
    @SubscribeEvent
    public static void onMobSpawn(EntityJoinLevelEvent event) {
        Mob mob;
        Level level;
        Entity entity;
        block16: {
            block15: {
                entity = event.getEntity();
                level = event.getLevel();
                if (!(entity instanceof Mob)) break block15;
                mob = (Mob)entity;
                if (!level.isClientSide()) break block16;
            }
            return;
        }
        ResourceKey dim = level.dimension();
        if (!level.dimension().equals(DimensionExpansionDimensions.DEEP_BENEATH)) {
            return;
        }
        if (mob.getType().getCategory() != MobCategory.MONSTER) {
            return;
        }
        CompoundTag tag = mob.getPersistentData();
        if (tag.getBoolean("deep_beneath.buff_applied")) {
            return;
        }
        tag.putBoolean("deep_beneath.buff_applied", true);
        AttributeInstance healthAttr = mob.getAttribute(Attributes.MAX_HEALTH);
        if (healthAttr != null) {
            double original = healthAttr.getBaseValue();
            if (mob.getType() == EntityType.ZOMBIE) {
                healthAttr.setBaseValue(original * 4.0);
            } else {
                healthAttr.setBaseValue(original * 2.0);
            }
            mob.setHealth((float)healthAttr.getValue());
        }
        AttributeInstance followRange = mob.getAttribute(Attributes.FOLLOW_RANGE);
        AttributeInstance knockbackResistance = mob.getAttribute(Attributes.KNOCKBACK_RESISTANCE);
        if (followRange != null) {
            followRange.setBaseValue(80.0);
        }
        if (knockbackResistance != null) {
            knockbackResistance.setBaseValue(1.0);
        }
        mob.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, Integer.MAX_VALUE, 0, false, false));
        if (entity.getType() == EntityType.GHAST) {
            mob.setCustomName((Component)Component.literal((String)"Overseer"));
            mob.setCustomNameVisible(false);
        }
        if (entity.getType() == EntityType.PIGLIN_BRUTE) {
            mob.setCustomName((Component)Component.literal((String)"Protector of the Deep"));
            mob.setCustomNameVisible(false);
        }
        if (entity.getType() == EntityType.VINDICATOR) {
            mob.setCustomName((Component)Component.literal((String)"Guardian of the Shadows"));
            mob.setCustomNameVisible(false);
        }
        if (entity.getType() == EntityType.ILLUSIONER) {
            mob.setCustomName((Component)Component.literal((String)"Wizard"));
            mob.setCustomNameVisible(false);
        }
    }
}

