/*
 * Decompiled with CFR 0.152.
 */
package com.lithiumcraft.dimension_expansion.structure;

import com.lithiumcraft.dimension_expansion.block.ModBlocks;
import com.lithiumcraft.dimension_expansion.block.OverworldReturnTeleporterBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class StructureBuilder {
    public static void buildDeepBeneathPlatform(ServerLevel level, BlockPos center) {
        int dz;
        int dx;
        BlockState cobble = Blocks.COBBLESTONE.defaultBlockState();
        BlockState teleporter = ((OverworldReturnTeleporterBlock)((Object)ModBlocks.OVERWORLD_RETURN_TELEPORTER.get())).defaultBlockState();
        for (dx = -2; dx <= 2; ++dx) {
            for (dz = -2; dz <= 2; ++dz) {
                for (int dy = 0; dy <= 3; ++dy) {
                    BlockPos target = center.offset(dx, dy, dz);
                    BlockState state = level.getBlockState(target);
                    level.setBlockAndUpdate(target, Blocks.AIR.defaultBlockState());
                }
            }
        }
        for (dx = -2; dx <= 2; ++dx) {
            for (dz = -2; dz <= 2; ++dz) {
                BlockPos pos = center.offset(dx, 0, dz);
                level.setBlockAndUpdate(pos, cobble);
            }
        }
        level.setBlockAndUpdate(center.above(), teleporter);
    }

    public static void buildStoneBlockPlatform(ServerLevel level, BlockPos center) {
        int z;
        int y;
        int x;
        BlockState shell = Blocks.STONE.defaultBlockState();
        BlockState floor = Blocks.STONE.defaultBlockState();
        BlockState teleporter = ((OverworldReturnTeleporterBlock)((Object)ModBlocks.OVERWORLD_RETURN_TELEPORTER.get())).defaultBlockState();
        int DH = 4;
        int R = 9;
        double outer = 9.5;
        double inner = 8.5;
        double smooth = 0.25;
        double rOuter2 = 95.0625;
        double rInner2 = 68.0625;
        for (x = -10; x <= 10; ++x) {
            for (y = 0; y <= 14; ++y) {
                for (z = -10; z <= 10; ++z) {
                    double d2 = x * x + (y - 4) * (y - 4) + z * z;
                    if (!(d2 < 68.0625)) continue;
                    level.setBlockAndUpdate(center.offset(x, y, z), Blocks.AIR.defaultBlockState());
                }
            }
        }
        for (int dx = -9; dx <= 9; ++dx) {
            for (int dz = -9; dz <= 9; ++dz) {
                level.setBlockAndUpdate(center.offset(dx, 0, dz), floor);
            }
        }
        level.setBlockAndUpdate(center, teleporter);
        for (x = -10; x <= 10; ++x) {
            for (y = 1; y <= 9; ++y) {
                for (z = -10; z <= 10; ++z) {
                    double dist2 = x * x + (y - 4) * (y - 4) + z * z;
                    if (!(dist2 >= 68.0) || !(dist2 <= 95.125)) continue;
                    level.setBlockAndUpdate(center.offset(x, y, z), shell);
                }
            }
        }
    }

    public static void buildMiningPlatform(ServerLevel level, BlockPos center) {
        BlockPos teleporterPos = center;
        BlockState teleporter = ((OverworldReturnTeleporterBlock)((Object)ModBlocks.OVERWORLD_RETURN_TELEPORTER.get())).defaultBlockState();
        level.setBlockAndUpdate(teleporterPos, teleporter);
    }
}

