/*
 * Decompiled with CFR 0.152.
 */
package com.lithiumcraft.dimension_expansion.util.teleport;

import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

public class TeleportMarkerData {
    private BlockPos targetPos;
    private ResourceKey<Level> targetDim;
    private ResourceLocation sourceBlockId;

    public TeleportMarkerData(BlockPos targetPos, ResourceKey<Level> targetDim, Block sourceBlock) {
        this.targetPos = targetPos;
        this.targetDim = targetDim;
        this.sourceBlockId = BuiltInRegistries.BLOCK.getKey((Object)sourceBlock);
    }

    public BlockPos getTargetPos() {
        return this.targetPos;
    }

    public ResourceKey<Level> getTargetDimension() {
        return this.targetDim;
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.putInt("x", this.targetPos.getX());
        tag.putInt("y", this.targetPos.getY());
        tag.putInt("z", this.targetPos.getZ());
        tag.putString("dimension", this.targetDim.location().toString());
        tag.putString("source_block", this.sourceBlockId.toString());
        return tag;
    }

    @Nullable
    public static TeleportMarkerData load(CompoundTag tag) {
        if (!(tag.contains("x") && tag.contains("y") && tag.contains("z") && tag.contains("dimension"))) {
            return null;
        }
        BlockPos pos = new BlockPos(tag.getInt("x"), tag.getInt("y"), tag.getInt("z"));
        ResourceKey dim = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.tryParse((String)tag.getString("dimension")));
        ResourceLocation blockId = tag.contains("source_block") ? ResourceLocation.tryParse((String)tag.getString("source_block")) : null;
        Block sourceBlock = blockId != null ? (Block)BuiltInRegistries.BLOCK.get(blockId) : Blocks.AIR;
        return new TeleportMarkerData(pos, (ResourceKey<Level>)dim, sourceBlock);
    }

    public Block getSourceBlock() {
        return (Block)BuiltInRegistries.BLOCK.get(this.sourceBlockId);
    }
}

