/*
 * Decompiled with CFR 0.152.
 */
package com.lithiumcraft.dimension_expansion.util.teleport;

import com.lithiumcraft.dimension_expansion.util.teleport.TeleportUtil;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public record TeleporterRules(ResourceKey<Level> targetDimension, boolean buildPlatform, BiFunction<ServerLevel, BlockPos, BlockPos> arrivalPositionFunction, @Nullable BiConsumer<ServerLevel, BlockPos> platformBuilder) {
    public BlockPos resolveArrival(ServerLevel level, BlockPos basePos) {
        return this.arrivalPositionFunction.apply(level, basePos);
    }

    public void maybeBuildPlatform(ServerLevel level, BlockPos center, Block teleporterBlock) {
        if (!this.buildPlatform || this.platformBuilder == null) {
            return;
        }
        if (TeleportUtil.hasNearbyTeleporter(level, center, teleporterBlock, 48)) {
            return;
        }
        if (!TeleportUtil.isPlatformReady((Level)level, center, teleporterBlock)) {
            this.platformBuilder.accept(level, center);
        }
    }
}

