/*
 * Decompiled with CFR 0.152.
 */
package com.lithiumcraft.dimension_expansion.worldgen.feature;

import com.mojang.serialization.Codec;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class CaveSpireFeature
extends Feature<NoneFeatureConfiguration> {
    private static final List<BlockState> BASE_BLOCKS = List.of(Blocks.STONE.defaultBlockState(), Blocks.COBBLESTONE.defaultBlockState(), Blocks.ANDESITE.defaultBlockState(), Blocks.INFESTED_STONE.defaultBlockState(), Blocks.MOSSY_COBBLESTONE.defaultBlockState());

    public CaveSpireFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> ctx) {
        int maxSafeHeight;
        boolean downward;
        WorldGenLevel level = ctx.level();
        RandomSource random = ctx.random();
        BlockPos origin = ctx.origin();
        BlockPos anchor = this.findValidAnchor((LevelAccessor)level, origin, downward = random.nextBoolean());
        if (anchor == null) {
            return false;
        }
        BlockPos start = downward ? anchor : anchor;
        int height = 8 + random.nextInt(14);
        int baseRadius = 6 + random.nextInt(4);
        int yMin = level.getMinBuildHeight() + 2;
        int yMax = level.getMaxBuildHeight() - 2;
        if (!level.isEmptyBlock(anchor.above()) && !level.isEmptyBlock(anchor.below())) {
            return false;
        }
        int maxSolidCount = 2;
        int solidHits = 0;
        int checkRange = height + 3;
        for (int dy = 0; dy < checkRange; ++dy) {
            BlockPos check = downward ? start.below(dy) : start.above(dy);
            BlockState checkState = level.getBlockState(check);
            if (checkState.isAir() || checkState.canBeReplaced() || ++solidHits <= maxSolidCount) continue;
            return false;
        }
        int n = maxSafeHeight = downward ? Math.min(anchor.getY(), level.getMaxBuildHeight() - 5) : Math.max(anchor.getY(), level.getMinBuildHeight() + 5);
        if (downward && anchor.getY() - height < level.getMinBuildHeight() + 5) {
            height = anchor.getY() - (level.getMinBuildHeight() + 5);
        }
        if (!downward && anchor.getY() + height > level.getMaxBuildHeight() - 5) {
            height = level.getMaxBuildHeight() - 5 - anchor.getY();
        }
        if (height <= 0) {
            return false;
        }
        if (downward && anchor.getY() < 40) {
            return false;
        }
        if (!downward && anchor.getY() > 280) {
            return false;
        }
        for (int i = 0; i < height; ++i) {
            int dy = downward ? -i : i;
            BlockPos layerCenter = start.offset(0, dy, 0);
            if (i == 0 && !downward) {
                layerCenter = layerCenter.below();
            }
            if (i == 0 && downward) {
                layerCenter = layerCenter.above();
            }
            if (layerCenter.getY() <= yMin || layerCenter.getY() >= yMax || !CaveSpireFeature.isReplaceable(level.getBlockState(layerCenter))) break;
            int radius = Math.max(1, (int)Math.round((double)baseRadius * (1.0 - (double)i / (double)height)));
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos target;
                    if (dx * dx + dz * dz > radius * radius || !CaveSpireFeature.isReplaceable(level.getBlockState(target = layerCenter.offset(dx, 0, dz)))) continue;
                    level.setBlock(target, this.chooseBlock(random), 2);
                }
            }
        }
        return true;
    }

    private static boolean isReplaceable(BlockState state) {
        return state.isAir() || state.canBeReplaced();
    }

    private BlockState chooseBlock(RandomSource random) {
        int r = random.nextInt(100);
        if (r < 55) {
            return Blocks.STONE.defaultBlockState();
        }
        if (r < 75) {
            return Blocks.ANDESITE.defaultBlockState();
        }
        if (r < 90) {
            return Blocks.COBBLESTONE.defaultBlockState();
        }
        if (r < 97) {
            return Blocks.MOSSY_COBBLESTONE.defaultBlockState();
        }
        return Blocks.INFESTED_STONE.defaultBlockState();
    }

    private boolean isSolidPatch(LevelAccessor level, BlockPos center, boolean downward) {
        int solidCount = 0;
        BlockPos base = downward ? center.above() : center.below();
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                BlockPos check = base.offset(dx, 0, dz);
                BlockState state = level.getBlockState(check);
                if (!state.isSolid() || CaveSpireFeature.isSpireBlock(state)) continue;
                ++solidCount;
            }
        }
        if (solidCount < 7) {
            return false;
        }
        BlockPos airCheck = downward ? center.below() : center.above();
        return level.getBlockState(airCheck).isAir();
    }

    @Nullable
    private BlockPos findValidAnchor(LevelAccessor level, BlockPos origin, boolean downward) {
        BlockPos.MutableBlockPos check = new BlockPos.MutableBlockPos();
        int searchRadius = 8;
        int minY = level.getMinBuildHeight() + 8;
        int maxY = level.getMaxBuildHeight() - 8;
        int yStart = Math.max(minY, origin.getY() - 48);
        int yEnd = Math.min(maxY, origin.getY() + 48);
        for (int tries = 0; tries < 32; ++tries) {
            int y;
            int dx = origin.getX() + level.getRandom().nextIntBetweenInclusive(-searchRadius, searchRadius);
            int dz = origin.getZ() + level.getRandom().nextIntBetweenInclusive(-searchRadius, searchRadius);
            if (downward) {
                for (y = yEnd; y >= yStart; --y) {
                    check.set(dx, y, dz);
                    if (!this.isSolidPatch(level, (BlockPos)check, true)) continue;
                    return check.immutable();
                }
                continue;
            }
            for (y = yStart; y <= yEnd; ++y) {
                check.set(dx, y, dz);
                if (!this.isSolidPatch(level, (BlockPos)check, false)) continue;
                return check.immutable();
            }
        }
        return null;
    }

    private static boolean isSpireBlock(BlockState state) {
        return state.is(Blocks.STONE) || state.is(Blocks.COBBLESTONE) || state.is(Blocks.ANDESITE) || state.is(Blocks.MOSSY_COBBLESTONE) || state.is(Blocks.INFESTED_STONE);
    }
}

