/*
 * Decompiled with CFR 0.152.
 */
package com.lithiumcraft.dimension_expansion.worldgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class StalagmiteFeature
extends Feature<NoneFeatureConfiguration> {
    private static final BlockState[] VARIANTS = new BlockState[]{Blocks.STONE.defaultBlockState(), Blocks.COBBLESTONE.defaultBlockState(), Blocks.ANDESITE.defaultBlockState(), Blocks.INFESTED_STONE.defaultBlockState()};

    public StalagmiteFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> ctx) {
        WorldGenLevel level = ctx.level();
        RandomSource random = ctx.random();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos().set((Vec3i)ctx.origin());
        while (pos.getY() > level.getMinBuildHeight() + 4 && level.getBlockState((BlockPos)pos).isAir()) {
            pos.move(Direction.DOWN);
        }
        if (!level.getBlockState((BlockPos)pos).isSolid()) {
            return false;
        }
        pos.move(Direction.UP);
        int height = Mth.nextInt((RandomSource)random, (int)8, (int)25);
        int baseRadius = Mth.nextInt((RandomSource)random, (int)3, (int)8);
        boolean placed = false;
        for (int y = 0; y < height; ++y) {
            double taper = 1.0 - (double)y / (double)height;
            int radius = Math.max(1, (int)((double)baseRadius * taper + 0.5));
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos placePos;
                    double dist = Math.sqrt(x * x + z * z);
                    if (!(dist <= (double)radius) || !level.getBlockState(placePos = pos.offset(x, y, z)).canBeReplaced()) continue;
                    BlockState chosen = VARIANTS[random.nextInt(VARIANTS.length)];
                    level.setBlock(placePos, chosen, 2);
                    placed = true;
                }
            }
        }
        if (!placed) {
            return false;
        }
        BlockPos tip = pos.offset(0, height, 0);
        if (level.getBlockState(tip).canBeReplaced()) {
            level.setBlock(tip, Blocks.COBBLESTONE_WALL.defaultBlockState(), 2);
        }
        this.decorateSides(level, (BlockPos)pos, height, baseRadius, random);
        return true;
    }

    private void decorateSides(WorldGenLevel level, BlockPos base, int height, int radius, RandomSource random) {
        block0: for (int i = 0; i < 40; ++i) {
            int z;
            int y;
            int x = Mth.nextInt((RandomSource)random, (int)(-radius), (int)radius);
            BlockPos target = base.offset(x, y = Mth.nextInt((RandomSource)random, (int)1, (int)(height - 1)), z = Mth.nextInt((RandomSource)random, (int)(-radius), (int)radius));
            if (!level.getBlockState(target).isSolid()) continue;
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockPos side = target.relative(dir);
                if (!level.getBlockState(side).isAir()) continue;
                if (random.nextBoolean()) {
                    level.setBlock(side, (BlockState)((BlockState)Blocks.COBBLESTONE_STAIRS.defaultBlockState().setValue((Property)StairBlock.FACING, (Comparable)dir.getOpposite())).setValue((Property)StairBlock.HALF, (Comparable)Half.BOTTOM), 2);
                    continue block0;
                }
                level.setBlock(side, Blocks.COBBLESTONE_SLAB.defaultBlockState(), 2);
                continue block0;
            }
        }
    }
}

