/*
 * Decompiled with CFR 0.152.
 */
package com.lithiumcraft.dimension_expansion.blockentity;

import com.lithiumcraft.dimension_expansion.block.ModBlocks;
import com.lithiumcraft.dimension_expansion.registry.ModSounds;
import com.lithiumcraft.dimension_expansion.structure.StructureBuilder;
import com.lithiumcraft.dimension_expansion.util.teleport.TeleportMarkerData;
import com.lithiumcraft.dimension_expansion.util.teleport.TeleporterRules;
import com.lithiumcraft.dimension_expansion.worldgen.DimensionExpansionDimensions;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.common.util.INBTSerializable;

public class TeleporterBlockEntity
extends BlockEntity
implements INBTSerializable<CompoundTag> {
    private BlockPos linkedPos = null;
    private String linkedDim = null;
    private static final Map<Block, ResourceKey<Level>> TELEPORT_TARGETS = Map.of((Block)ModBlocks.DEEP_BENEATH_TELEPORTER.get(), DimensionExpansionDimensions.DEEP_BENEATH, (Block)ModBlocks.MINING_TELEPORTER.get(), DimensionExpansionDimensions.MINING, (Block)ModBlocks.STONE_BLOCK_TELEPORTER.get(), DimensionExpansionDimensions.STONE_BLOCK);
    private TeleportMarkerData linkedTeleporter = null;
    private static final Map<Block, TeleporterRules> TELEPORT_RULES = Map.of((Block)ModBlocks.DEEP_BENEATH_TELEPORTER.get(), new TeleporterRules(DimensionExpansionDimensions.DEEP_BENEATH, true, (level, base) -> new BlockPos(base.getX(), 150, base.getZ()), StructureBuilder::buildDeepBeneathPlatform), (Block)ModBlocks.MINING_TELEPORTER.get(), new TeleporterRules(DimensionExpansionDimensions.MINING, true, (level, base) -> TeleporterBlockEntity.findSurfacePosition(level, base.getX(), base.getZ()), StructureBuilder::buildMiningPlatform), (Block)ModBlocks.STONE_BLOCK_TELEPORTER.get(), new TeleporterRules(DimensionExpansionDimensions.STONE_BLOCK, true, (level, base) -> new BlockPos(base.getX(), 192, base.getZ()), StructureBuilder::buildStoneBlockPlatform));

    public TeleporterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static void tickServer(Level level, BlockPos pos, BlockState state, TeleporterBlockEntity be) {
    }

    public void teleport(ServerPlayer player) {
        BlockPos targetTeleporterPos;
        BlockState linkedBlockState;
        Level level;
        if (player == null || this.level == null || this.level.isClientSide || !((level = this.level) instanceof ServerLevel)) {
            return;
        }
        ServerLevel sourceLevel = (ServerLevel)level;
        MinecraftServer server = sourceLevel.getServer();
        ResourceKey sourceDim = sourceLevel.dimension();
        BlockPos sourcePos = this.getBlockPos();
        Block block = this.getBlockState().getBlock();
        BlockState blockState = linkedBlockState = this.linkedTeleporter != null ? this.linkedTeleporter.getSourceBlock().defaultBlockState() : null;
        if (block == ModBlocks.OVERWORLD_RETURN_TELEPORTER.get()) {
            if (this.linkedTeleporter == null) {
                player.sendSystemMessage((Component)Component.literal((String)"This return teleporter is not linked."));
                return;
            }
            BlockPos targetPos = this.linkedTeleporter.getTargetPos();
            ResourceKey<Level> targetDim = this.linkedTeleporter.getTargetDimension();
            ServerLevel targetLevel = server.getLevel(targetDim);
            if (targetLevel == null) {
                return;
            }
            BlockState atTarget = targetLevel.getBlockState(targetPos);
            if ((atTarget.isAir() || atTarget.canBeReplaced()) && linkedBlockState != null) {
                targetLevel.setBlockAndUpdate(targetPos, linkedBlockState);
            }
            BlockPos arrival = targetPos.above();
            player.teleportTo(targetLevel, (double)arrival.getX() + 0.5, (double)arrival.getY(), (double)arrival.getZ() + 0.5, player.getYRot(), player.getXRot());
            targetLevel.playSound(null, targetPos, ModSounds.TELEPORTER_ACTIVATE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return;
        }
        TeleporterRules rules = TELEPORT_RULES.get(block);
        if (rules == null) {
            System.err.println("Missing TeleporterRules for block: " + String.valueOf(block));
            player.sendSystemMessage((Component)Component.literal((String)"This teleporter is not linked to a dimension."));
            return;
        }
        ResourceKey<Level> targetDim = rules.targetDimension();
        boolean goingToTarget = !sourceDim.equals(targetDim);
        ServerLevel targetLevel = server.getLevel(targetDim);
        if (targetLevel == null) {
            return;
        }
        if (goingToTarget) {
            BlockPos baseTargetPos;
            targetTeleporterPos = baseTargetPos = rules.resolveArrival(targetLevel, sourcePos);
            Optional<TeleporterBlockEntity> nearby = this.findLinkedTeleporterNearby(targetLevel, baseTargetPos, (Block)ModBlocks.OVERWORLD_RETURN_TELEPORTER.get(), 48);
            if (nearby.isPresent()) {
                targetTeleporterPos = nearby.get().getBlockPos();
            } else {
                rules.maybeBuildPlatform(targetLevel, baseTargetPos, (Block)ModBlocks.OVERWORLD_RETURN_TELEPORTER.get());
                BlockEntity be = targetLevel.getBlockEntity(baseTargetPos);
                if (!(be instanceof TeleporterBlockEntity)) {
                    be = targetLevel.getBlockEntity(baseTargetPos.above());
                }
                if (be instanceof TeleporterBlockEntity) {
                    TeleporterBlockEntity targetTeleporter = (TeleporterBlockEntity)be;
                    targetTeleporter.linkedTeleporter = new TeleportMarkerData(sourcePos, (ResourceKey<Level>)sourceLevel.dimension(), block);
                    targetTeleporter.setChanged();
                }
            }
            this.linkedTeleporter = new TeleportMarkerData(targetTeleporterPos, targetDim, (Block)ModBlocks.OVERWORLD_RETURN_TELEPORTER.get());
            this.setChanged();
        } else {
            BlockPos blockPos = targetTeleporterPos = this.linkedTeleporter != null ? this.linkedTeleporter.getTargetPos() : sourcePos;
            if (!targetLevel.getBlockState(targetTeleporterPos).is(block)) {
                targetLevel.setBlockAndUpdate(targetTeleporterPos, block.defaultBlockState());
            }
        }
        BlockPos arrival = this.findArrivalOffset((Level)targetLevel, targetTeleporterPos.above());
        player.teleportTo(targetLevel, (double)arrival.getX() + 0.5, (double)arrival.getY(), (double)arrival.getZ() + 0.5, player.getYRot(), player.getXRot());
        targetLevel.playSound(null, arrival, ModSounds.TELEPORTER_ACTIVATE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private Optional<TeleporterBlockEntity> findLinkedTeleporterNearby(ServerLevel level, BlockPos center, Block returnTeleporterBlock, int radius) {
        for (BlockPos pos : BlockPos.withinManhattan((BlockPos)center, (int)radius, (int)radius, (int)radius)) {
            BlockEntity be;
            if (!level.getBlockState(pos).is(returnTeleporterBlock) || !((be = level.getBlockEntity(pos)) instanceof TeleporterBlockEntity)) continue;
            TeleporterBlockEntity tbe = (TeleporterBlockEntity)be;
            return Optional.of(tbe);
        }
        return Optional.empty();
    }

    public static BlockPos findSurfacePosition(ServerLevel level, int x, int z) {
        int y = level.getChunkSource().getGenerator().getFirstFreeHeight(x, z, Heightmap.Types.WORLD_SURFACE, (LevelHeightAccessor)level, level.getChunkSource().randomState());
        return new BlockPos(x, y, z);
    }

    private BlockPos findArrivalOffset(Level level, BlockPos center) {
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos offset = center.relative(dir);
            if (!level.getBlockState(offset).isAir() && !level.getBlockState(offset).canBeReplaced()) continue;
            return offset;
        }
        return center;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        super.saveAdditional(tag, lookup);
        if (this.linkedTeleporter != null) {
            tag.put("linked_teleporter", (Tag)this.linkedTeleporter.save());
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        super.loadAdditional(tag, lookup);
        if (tag.contains("linked_teleporter", 10)) {
            this.linkedTeleporter = TeleportMarkerData.load(tag.getCompound("linked_teleporter"));
        }
    }

    public CompoundTag serializeNBT(HolderLookup.Provider lookup) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, lookup);
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider lookup, CompoundTag tag) {
        this.loadAdditional(tag, lookup);
    }
}

