/*
 * Decompiled with CFR 0.152.
 */
package com.lithiumcraft.dimension_expansion.event;

import com.lithiumcraft.dimension_expansion.worldgen.DimensionExpansionDimensions;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;

@EventBusSubscriber(modid="dimension_expansion")
public class DeepBeneathMobBuffHandler {
    @SubscribeEvent
    public static void onMobSpawn(EntityJoinLevelEvent event) {
        Mob mob;
        Level level;
        Entity entity;
        block11: {
            block10: {
                entity = event.getEntity();
                level = event.getLevel();
                if (!(entity instanceof Mob)) break block10;
                mob = (Mob)entity;
                if (!level.isClientSide()) break block11;
            }
            return;
        }
        if (!level.dimension().equals(DimensionExpansionDimensions.DEEP_BENEATH)) {
            return;
        }
        AttributeInstance healthAttr = mob.getAttribute(Attributes.MAX_HEALTH);
        if (healthAttr != null && healthAttr.getBaseValue() < 2048.0) {
            double original = healthAttr.getBaseValue();
            healthAttr.setBaseValue(original * 2.0);
            mob.setHealth((float)healthAttr.getValue());
        }
        if (mob instanceof LivingEntity) {
            Mob living = mob;
            if (entity.getType() == EntityType.GHAST) {
                living.setCustomName((Component)Component.literal((String)"Overseer"));
                living.setCustomNameVisible(false);
            }
            if (entity.getType() == EntityType.PIGLIN_BRUTE) {
                living.setCustomName((Component)Component.literal((String)"Protector of the Deep"));
                living.setCustomNameVisible(false);
            }
            if (entity.getType() == EntityType.VINDICATOR) {
                living.setCustomName((Component)Component.literal((String)"Guardian of the Shadows"));
                living.setCustomNameVisible(false);
            }
            if (entity.getType() == EntityType.ILLUSIONER) {
                living.setCustomName((Component)Component.literal((String)"Wizard"));
                living.setCustomNameVisible(false);
            }
            living.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, Integer.MAX_VALUE, 0, false, false));
        }
    }
}

