/*
 * Decompiled with CFR 0.152.
 */
package com.lithiumcraft.dimension_expansion.event;

import com.lithiumcraft.dimension_expansion.worldgen.DimensionExpansionDimensions;
import java.util.Iterator;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;

@EventBusSubscriber(modid="dimension_expansion")
public class DeepBeneathMobLootHandler {
    @SubscribeEvent
    public static void onMobDrops(LivingDropsEvent event) {
        Level level = event.getEntity().level();
        if (level.isClientSide() || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!serverLevel.dimension().equals(DimensionExpansionDimensions.DEEP_BENEATH)) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (entity.getType() == EntityType.GHAST) {
            Iterator it = event.getDrops().iterator();
            while (it.hasNext()) {
                ItemEntity drop = (ItemEntity)it.next();
                if (drop.getItem().getItem() != Items.GHAST_TEAR) continue;
                it.remove();
            }
            int count = 1 + level.random.nextInt(3);
            event.getDrops().add(new ItemEntity(level, entity.getX(), entity.getY(), entity.getZ(), new ItemStack((ItemLike)Items.BLAZE_POWDER, count)));
        } else if (entity.getType() == EntityType.CAVE_SPIDER) {
            int count = 1 + level.random.nextInt(2);
            event.getDrops().add(new ItemEntity(level, entity.getX(), entity.getY(), entity.getZ(), new ItemStack((ItemLike)Items.FERMENTED_SPIDER_EYE, count)));
        }
    }
}

