/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.plugin.jei.category;

import com.buuz135.industrial.plugin.jei.IndustrialRecipeTypes;
import com.buuz135.industrial.recipe.LaserDrillFluidRecipe;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.client.screen.asset.DefaultAssetProvider;
import com.hrznstudio.titanium.util.AssetUtil;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.fluids.FluidStack;

public class LaserDrillFluidCategory
implements IRecipeCategory<LaserDrillFluidRecipe> {
    private final IDrawableStatic smallTank;
    private IGuiHelper guiHelper;

    public LaserDrillFluidCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
        this.smallTank = guiHelper.createDrawable(DefaultAssetProvider.DEFAULT_LOCATION, 238, 4, 12, 13);
    }

    public RecipeType<LaserDrillFluidRecipe> getRecipeType() {
        return IndustrialRecipeTypes.LASER_FLUID;
    }

    public Component getTitle() {
        return Component.m_237113_((String)"Laser Drill Fluids");
    }

    public IDrawable getBackground() {
        return this.guiHelper.drawableBuilder(new ResourceLocation("industrialforegoing", "textures/gui/jei.png"), 0, 0, 52, 26).addPadding(0, 60, 35, 65).build();
    }

    public IDrawable getIcon() {
        return null;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, LaserDrillFluidRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 36, 5).addIngredients(recipe.catalyst);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 101, 6).setFluidRenderer(200L, false, 12, 13).setOverlay((IDrawable)this.smallTank, 0, 0).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)FluidStack.loadFluidStackFromNBT((CompoundTag)recipe.output));
    }

    public void draw(LaserDrillFluidRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        int recipeWidth = 152;
        if (recipe.pointer > 0) {
            AssetUtil.drawAsset((GuiGraphics)guiGraphics, (Screen)Minecraft.m_91087_().f_91080_, (IAsset)DefaultAssetProvider.DEFAULT_PROVIDER.getAsset(AssetTypes.BUTTON_ARROW_LEFT), (int)0, (int)70);
        }
        if (recipe.pointer < recipe.rarity.length - 1) {
            AssetUtil.drawAsset((GuiGraphics)guiGraphics, (Screen)Minecraft.m_91087_().f_91080_, (IAsset)DefaultAssetProvider.DEFAULT_PROVIDER.getAsset(AssetTypes.BUTTON_ARROW_RIGHT), (int)137, (int)70);
        }
        AssetUtil.drawAsset((GuiGraphics)guiGraphics, (Screen)Minecraft.m_91087_().f_91080_, (IAsset)DefaultAssetProvider.DEFAULT_PROVIDER.getAsset(AssetTypes.TANK_SMALL), (int)98, (int)3);
        ResourceLocation toasts = new ResourceLocation("textures/gui/toasts.png");
        int n = recipeWidth / 10 * 2;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        guiGraphics.m_280163_(toasts, n, 30 + (9 + 2) * 3, 216.0f, 0.0f, 20, 20, 256, 256);
        int n2 = recipeWidth / 10 * 7;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        guiGraphics.m_280163_(toasts, n2, 30 + (9 + 2) * 3, 216.0f, 0.0f, 20, 20, 256, 256);
        ResourceLocation icons = new ResourceLocation("forge", "textures/gui/icons.png");
        int n3 = recipeWidth / 10 * 7 + 1;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        guiGraphics.m_280218_(icons, n3, 30 + (9 + 2) * 3 + 3, 0, 16, 16, 16);
        String minY = Component.m_237115_((String)"text.industrialforegoing.miny").getString() + " " + recipe.rarity[recipe.pointer].depth_min;
        String maxY = Component.m_237115_((String)"text.industrialforegoing.maxy").getString() + " " + recipe.rarity[recipe.pointer].depth_max;
        String biomes = Component.m_237115_((String)"text.industrialforegoing.biomes").getString();
        guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, ChatFormatting.DARK_GRAY + minY, recipeWidth / 10, 30, 0, false);
        if (!LaserDrillFluidRecipe.EMPTY.equals((Object)recipe.entity)) {
            String wight = "Over: " + Component.m_237115_((String)("entity." + recipe.entity.toString().replace(":", "."))).getString();
            Font font = Minecraft.m_91087_().f_91062_;
            String string = ChatFormatting.DARK_GRAY + wight;
            int n4 = recipeWidth / 10;
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            guiGraphics.m_280056_(font, string, n4, 30 + (9 + 2), 0, false);
        }
        guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, ChatFormatting.DARK_GRAY + maxY, recipeWidth / 10 * 6, 30, 0, false);
        Font font = Minecraft.m_91087_().f_91062_;
        String string = ChatFormatting.DARK_GRAY + ChatFormatting.UNDERLINE + biomes;
        int n5 = recipeWidth / 2 - Minecraft.m_91087_().f_91062_.m_92895_(biomes) / 2;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        guiGraphics.m_280056_(font, string, n5, 30 + (9 + 2) * 2, 0, false);
    }

    public List<Component> getTooltipStrings(LaserDrillFluidRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (mouseX > 0.0 && mouseX < 15.0 && mouseY > 70.0 && mouseY < 85.0 && recipe.pointer > 0) {
            return Collections.singletonList(Component.m_237115_((String)"text.industrialforegoing.button.jei.prev_rarity"));
        }
        if (mouseX > 137.0 && mouseX < 152.0 && mouseY > 70.0 && mouseY < 85.0 && recipe.pointer < recipe.rarity.length - 1) {
            return Collections.singletonList(Component.m_237115_((String)"text.industrialforegoing.button.jei.next_rarity"));
        }
        if (mouseX > 26.0 && mouseX < 46.0) {
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            if (mouseY > (double)(30 + (9 + 2) * 3)) {
                Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
                if (mouseY < (double)(30 + (9 + 2) * 3 + 20)) {
                    ArrayList<Component> biomes = new ArrayList<Component>();
                    biomes.add((Component)Component.m_237115_((String)"text.industrialforegoing.tooltip.whitelisted_biomes").m_130940_(ChatFormatting.UNDERLINE).m_130940_(ChatFormatting.GOLD));
                    if (recipe.rarity[recipe.pointer].whitelist.length == 0) {
                        biomes.add((Component)Component.m_237113_((String)"- Any"));
                    } else {
                        for (ResourceKey registryKey : recipe.rarity[recipe.pointer].whitelist) {
                            biomes.add((Component)Component.m_237113_((String)"- ").m_7220_((Component)Component.m_237115_((String)("biome." + registryKey.m_135782_().m_135827_() + "." + registryKey.m_135782_().m_135815_()))));
                        }
                    }
                    return biomes;
                }
            }
        }
        if (mouseX > 104.0 && mouseX < 124.0) {
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            if (mouseY > (double)(30 + (9 + 2) * 3)) {
                Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
                if (mouseY < (double)(30 + (9 + 2) * 3 + 20)) {
                    ArrayList<Component> biomes = new ArrayList<Component>();
                    biomes.add((Component)Component.m_237115_((String)"text.industrialforegoing.tooltip.blacklisted_biomes").m_130940_(ChatFormatting.UNDERLINE).m_130940_(ChatFormatting.GOLD));
                    if (recipe.rarity[recipe.pointer].blacklist.length == 0) {
                        biomes.add((Component)Component.m_237113_((String)"- None"));
                    } else {
                        for (ResourceKey registryKey : recipe.rarity[recipe.pointer].blacklist) {
                            biomes.add((Component)Component.m_237113_((String)"- ").m_7220_((Component)Component.m_237115_((String)("biome." + registryKey.m_135782_().m_135827_() + "." + registryKey.m_135782_().m_135815_()))));
                        }
                    }
                    return biomes;
                }
            }
        }
        return Collections.emptyList();
    }

    public boolean handleInput(LaserDrillFluidRecipe recipe, double mouseX, double mouseY, InputConstants.Key input) {
        if (mouseX > 0.0 && mouseX < 15.0 && mouseY > 70.0 && mouseY < 85.0 && recipe.pointer > 0) {
            --recipe.pointer;
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            return true;
        }
        if (mouseX > 137.0 && mouseX < 152.0 && mouseY > 70.0 && mouseY < 85.0 && recipe.pointer < recipe.rarity.length - 1) {
            ++recipe.pointer;
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            return true;
        }
        return false;
    }
}

