/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.api.conveyor;

import com.buuz135.industrial.api.IBlockContainer;
import com.buuz135.industrial.api.conveyor.ConveyorUpgradeFactory;
import com.buuz135.industrial.api.conveyor.gui.IGuiComponent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.util.INBTSerializable;

public abstract class ConveyorUpgrade
implements INBTSerializable<CompoundTag> {
    private IBlockContainer container;
    private ConveyorUpgradeFactory factory;
    private Direction side;

    public ConveyorUpgrade(IBlockContainer container, ConveyorUpgradeFactory factory, Direction side) {
        this.container = container;
        this.factory = factory;
        this.side = side;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        return null;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
    }

    public boolean onUpgradeActivated(Player player, InteractionHand hand) {
        return false;
    }

    public Collection<ItemStack> getDrops() {
        return Collections.singleton(new ItemStack((ItemLike)this.getFactory().getUpgradeItem(), 1));
    }

    public IBlockContainer getContainer() {
        return this.container;
    }

    public Level getWorld() {
        return this.getContainer().getBlockWorld();
    }

    public BlockPos getPos() {
        return this.getContainer().getBlockPosition();
    }

    public ConveyorUpgradeFactory getFactory() {
        return this.factory;
    }

    public Direction getSide() {
        return this.side;
    }

    public void update() {
    }

    public void handleEntity(Entity entity) {
    }

    public void onUpgradeRemoved() {
    }

    public int getRedstoneOutput() {
        return 0;
    }

    public VoxelShape getBoundingBox() {
        return Shapes.empty();
    }

    public boolean hasGui() {
        return false;
    }

    public void handleButtonInteraction(int buttonId, CompoundTag compound) {
    }

    public void addComponentsToGui(List<IGuiComponent> componentList) {
    }

    public boolean ignoresCollision() {
        return false;
    }
}

