/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.agriculturehusbandry.tile;

import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.config.machine.resourceproduction.SimulatedHydroponicBedConfig;
import com.buuz135.industrial.item.HydroponicSimulationProcessorItem;
import com.buuz135.industrial.module.ModuleAgricultureHusbandry;
import com.buuz135.industrial.utils.IFAttachments;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class SimulatedHydroponicBedTile
extends IndustrialWorkingTile<SimulatedHydroponicBedTile> {
    @Save
    private final SidedInventoryComponent<SimulatedHydroponicBedTile> output = (SidedInventoryComponent)new SidedInventoryComponent("output", 45, 22, 21, 0).setColor(DyeColor.ORANGE).setRange(7, 3).setInputFilter((stack, integer) -> false);
    @Save
    private final SidedInventoryComponent<SimulatedHydroponicBedTile> simulation_slot;
    @Save
    private final SidedInventoryComponent<SimulatedHydroponicBedTile> seed;
    private HydroponicSimulationProcessorItem.Simulation simulation;

    public SimulatedHydroponicBedTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleAgricultureHusbandry.SIMULATED_HYDROPONIC_BED, SimulatedHydroponicBedConfig.powerPerOperation, blockPos, blockState);
        this.addInventory((InventoryComponent)this.output);
        this.simulation_slot = (SidedInventoryComponent)new SidedInventoryComponent("simulation", 106, 80, 1, 1).setColor(DyeColor.LIME).setInputFilter((stack, integer) -> stack.getItem().equals(ModuleAgricultureHusbandry.HYDROPONIC_SIMULATION_PROCESSOR.get())).setOutputFilter((stack, integer) -> false).setOnSlotChanged((itemStack, integer) -> {
            this.simulation = null;
        });
        this.addInventory((InventoryComponent)this.simulation_slot);
        this.seed = (SidedInventoryComponent)new SidedInventoryComponent("seed", 79, 80, 1, 2).setColor(DyeColor.CYAN).setInputFilter((stack, integer) -> true).setOutputFilter((stack, integer) -> false);
        this.addInventory((InventoryComponent)this.seed);
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        if (this.hasEnergy(SimulatedHydroponicBedConfig.powerPerOperation)) {
            ItemStack simulationProcessor = this.simulation_slot.getStackInSlot(0);
            ItemStack seed = this.seed.getStackInSlot(0);
            if (!seed.isEmpty() && !simulationProcessor.isEmpty() && simulationProcessor.getItem() instanceof HydroponicSimulationProcessorItem) {
                if (this.simulation == null) {
                    this.simulation = new HydroponicSimulationProcessorItem.Simulation((CompoundTag)simulationProcessor.get(IFAttachments.HYDROPONIC_SIMULATION_PROCESSOR));
                }
                if (!ItemStack.isSameItem((ItemStack)seed, (ItemStack)this.simulation.getCrop())) {
                    return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
                }
                ItemStack crop = this.simulation.getCrop();
                long executions = this.simulation.getExecutions();
                if (!crop.isEmpty() && executions > 0L) {
                    double efficiency = Math.floor(HydroponicSimulationProcessorItem.calculateEfficiency(executions) * 100.0) / 100.0;
                    ArrayList<ItemStack> generatedDrops = new ArrayList<ItemStack>();
                    for (HydroponicSimulationProcessorItem.CountedStack simulationStack : this.simulation.getStats()) {
                        ItemStack statStack = simulationStack.stack();
                        long statAmount = simulationStack.amount();
                        double amount = (double)statAmount / (double)executions * efficiency;
                        if (amount >= 1.0) {
                            int fullAmount = (int)Math.floor(amount);
                            ItemStack drop = statStack.copy();
                            drop.setCount(fullAmount);
                            generatedDrops.add(drop);
                            double fraction = amount - (double)fullAmount;
                            if (!(fraction > 0.0) || !(this.level.random.nextDouble() < fraction)) continue;
                            ItemStack extraDrop = statStack.copy();
                            extraDrop.setCount(1);
                            generatedDrops.add(extraDrop);
                            continue;
                        }
                        if (!(amount > 0.0) || !(this.level.random.nextDouble() < amount)) continue;
                        ItemStack drop = statStack.copy();
                        drop.setCount(1);
                        generatedDrops.add(drop);
                    }
                    if (this.level.random.nextDouble() <= SimulatedHydroponicBedConfig.chanceToIncreaseExecutions) {
                        ArrayList<ItemStack> boostDrops = new ArrayList<ItemStack>();
                        for (HydroponicSimulationProcessorItem.CountedStack simulationStack : this.simulation.getStats()) {
                            ItemStack statStack = simulationStack.stack();
                            long statAmount = simulationStack.amount();
                            double amount = (double)statAmount / (double)executions;
                            if (amount >= 1.0) {
                                int fullAmount = (int)Math.floor(amount);
                                ItemStack drop = statStack.copy();
                                drop.setCount(fullAmount);
                                boostDrops.add(drop);
                                double fraction = amount - (double)fullAmount;
                                if (!(fraction > 0.0) || !(this.level.random.nextDouble() < fraction)) continue;
                                ItemStack extraDrop = statStack.copy();
                                extraDrop.setCount(1);
                                boostDrops.add(extraDrop);
                                continue;
                            }
                            if (!(amount > 0.0) || !(this.level.random.nextDouble() < amount)) continue;
                            ItemStack drop = statStack.copy();
                            drop.setCount(1);
                            boostDrops.add(drop);
                        }
                        this.simulation.acceptExecution(crop, boostDrops);
                        simulationProcessor.set(IFAttachments.HYDROPONIC_SIMULATION_PROCESSOR, (Object)this.simulation.toNBT((HolderLookup.Provider)this.level.registryAccess()));
                    }
                    generatedDrops.forEach(stack -> ItemHandlerHelper.insertItem(this.output, (ItemStack)stack, (boolean)false));
                    return new IndustrialWorkingTile.WorkAction(this, 1.0f, SimulatedHydroponicBedConfig.powerPerOperation);
                }
            }
        }
        return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
    }

    @Override
    public int getMaxProgress() {
        return SimulatedHydroponicBedConfig.maxProgress;
    }

    @Nonnull
    public SimulatedHydroponicBedTile getSelf() {
        return this;
    }

    protected EnergyStorageComponent<SimulatedHydroponicBedTile> createEnergyStorage() {
        return new EnergyStorageComponent(SimulatedHydroponicBedConfig.maxStoredPower, 10, 20);
    }
}

