/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.tool;

import com.buuz135.industrial.block.tool.tile.InfinityBackpackTile;
import com.buuz135.industrial.module.ModuleTool;
import com.hrznstudio.titanium.block.RotatableBlock;
import com.hrznstudio.titanium.datagenerator.loot.block.BasicBlockLootTables;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class InfinityBackpackBlock
extends RotatableBlock<InfinityBackpackTile> {
    public static VoxelShape NORTH_SHAPE = Stream.of(Block.box((double)1.5, (double)0.0, (double)6.0, (double)14.5, (double)17.0, (double)15.0), Block.box((double)-1.5, (double)1.0, (double)8.0, (double)4.5, (double)7.0, (double)14.0), Block.box((double)1.5, (double)0.0, (double)3.0, (double)14.5, (double)10.0, (double)6.0), Block.box((double)11.5, (double)1.0, (double)8.0, (double)17.5, (double)7.0, (double)14.0), Block.box((double)1.25, (double)12.0, (double)5.75, (double)12.25, (double)14.0, (double)13.75), Block.box((double)2.5, (double)6.0, (double)2.75, (double)13.5, (double)8.0, (double)10.75), Block.box((double)3.5, (double)2.0, (double)15.0, (double)7.5, (double)17.0, (double)17.0), Block.box((double)8.5, (double)2.0, (double)15.0, (double)12.5, (double)17.0, (double)17.0), Block.box((double)4.5, (double)17.0, (double)12.0, (double)11.5, (double)19.0, (double)14.0), Block.box((double)4.5, (double)-1.0, (double)2.0, (double)11.5, (double)1.0, (double)9.0), Block.box((double)5.5, (double)0.0, (double)1.0, (double)10.5, (double)4.0, (double)3.0), Block.box((double)5.0, (double)-0.5, (double)0.5, (double)11.0, (double)4.5, (double)3.5), Block.box((double)6.5, (double)18.25, (double)12.5, (double)9.5, (double)19.25, (double)13.5)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static VoxelShape EAST_SHAPE = Stream.of(Block.box((double)1.0, (double)0.0, (double)1.5, (double)10.0, (double)17.0, (double)14.5), Block.box((double)2.0, (double)1.0, (double)-1.5, (double)8.0, (double)7.0, (double)4.5), Block.box((double)10.0, (double)0.0, (double)1.5, (double)13.0, (double)10.0, (double)14.5), Block.box((double)2.0, (double)1.0, (double)11.5, (double)8.0, (double)7.0, (double)17.5), Block.box((double)2.25, (double)12.0, (double)1.25, (double)10.25, (double)14.0, (double)12.25), Block.box((double)5.25, (double)6.0, (double)2.5, (double)13.25, (double)8.0, (double)13.5), Block.box((double)-1.0, (double)2.0, (double)3.5, (double)1.0, (double)17.0, (double)7.5), Block.box((double)-1.0, (double)2.0, (double)8.5, (double)1.0, (double)17.0, (double)12.5), Block.box((double)2.0, (double)17.0, (double)4.5, (double)4.0, (double)19.0, (double)11.5), Block.box((double)7.0, (double)-1.0, (double)4.5, (double)14.0, (double)1.0, (double)11.5), Block.box((double)13.0, (double)0.0, (double)5.5, (double)15.0, (double)4.0, (double)10.5), Block.box((double)12.5, (double)-0.5, (double)5.0, (double)15.5, (double)4.5, (double)11.0), Block.box((double)2.5, (double)18.25, (double)6.5, (double)3.5, (double)19.25, (double)9.5)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static VoxelShape SOUTH_SHAPE = Stream.of(Block.box((double)1.5, (double)0.0, (double)1.0, (double)14.5, (double)17.0, (double)10.0), Block.box((double)11.5, (double)1.0, (double)2.0, (double)17.5, (double)7.0, (double)8.0), Block.box((double)1.5, (double)0.0, (double)10.0, (double)14.5, (double)10.0, (double)13.0), Block.box((double)-1.5, (double)1.0, (double)2.0, (double)4.5, (double)7.0, (double)8.0), Block.box((double)3.75, (double)12.0, (double)2.25, (double)14.75, (double)14.0, (double)10.25), Block.box((double)2.5, (double)6.0, (double)5.25, (double)13.5, (double)8.0, (double)13.25), Block.box((double)8.5, (double)2.0, (double)-1.0, (double)12.5, (double)17.0, (double)1.0), Block.box((double)3.5, (double)2.0, (double)-1.0, (double)7.5, (double)17.0, (double)1.0), Block.box((double)4.5, (double)17.0, (double)2.0, (double)11.5, (double)19.0, (double)4.0), Block.box((double)4.5, (double)-1.0, (double)7.0, (double)11.5, (double)1.0, (double)14.0), Block.box((double)5.5, (double)0.0, (double)13.0, (double)10.5, (double)4.0, (double)15.0), Block.box((double)5.0, (double)-0.5, (double)12.5, (double)11.0, (double)4.5, (double)15.5), Block.box((double)6.5, (double)18.25, (double)2.5, (double)9.5, (double)19.25, (double)3.5)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static VoxelShape WEST_SHAPE = Stream.of(Block.box((double)6.0, (double)0.0, (double)1.5, (double)15.0, (double)17.0, (double)14.5), Block.box((double)8.0, (double)1.0, (double)11.5, (double)14.0, (double)7.0, (double)17.5), Block.box((double)3.0, (double)0.0, (double)1.5, (double)6.0, (double)10.0, (double)14.5), Block.box((double)8.0, (double)1.0, (double)-1.5, (double)14.0, (double)7.0, (double)4.5), Block.box((double)5.75, (double)12.0, (double)3.75, (double)13.75, (double)14.0, (double)14.75), Block.box((double)2.75, (double)6.0, (double)2.5, (double)10.75, (double)8.0, (double)13.5), Block.box((double)15.0, (double)2.0, (double)8.5, (double)17.0, (double)17.0, (double)12.5), Block.box((double)15.0, (double)2.0, (double)3.5, (double)17.0, (double)17.0, (double)7.5), Block.box((double)12.0, (double)17.0, (double)4.5, (double)14.0, (double)19.0, (double)11.5), Block.box((double)2.0, (double)-1.0, (double)4.5, (double)9.0, (double)1.0, (double)11.5), Block.box((double)1.0, (double)0.0, (double)5.5, (double)3.0, (double)4.0, (double)10.5), Block.box((double)0.5, (double)-0.5, (double)5.0, (double)3.5, (double)4.5, (double)11.0), Block.box((double)12.5, (double)18.25, (double)6.5, (double)13.5, (double)19.25, (double)9.5)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    public InfinityBackpackBlock() {
        super("infinity_backpack", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK), InfinityBackpackTile.class);
    }

    public BlockEntityType.BlockEntitySupplier<?> getTileEntityFactory() {
        return InfinityBackpackTile::new;
    }

    @NotNull
    public RotatableBlock.RotationType getRotationType() {
        return RotatableBlock.RotationType.FOUR_WAY;
    }

    public List<ItemStack> getDrops(BlockState p_60537_, LootParams.Builder builder) {
        NonNullList stacks = NonNullList.create();
        BlockEntity tile = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (tile instanceof InfinityBackpackTile) {
            InfinityBackpackTile infinityBackpackTile = (InfinityBackpackTile)tile;
            stacks.add((Object)infinityBackpackTile.getBackpack());
        }
        return stacks;
    }

    public LootTable.Builder getLootTable(@Nonnull BasicBlockLootTables blockLootTables) {
        return blockLootTables.droppingNothing();
    }

    public NonNullList<ItemStack> getDynamicDrops(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        return NonNullList.create();
    }

    public Item asItem() {
        return (Item)ModuleTool.INFINITY_BACKPACK.get();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        BlockEntity tile = level.getBlockEntity(pos);
        if (tile instanceof InfinityBackpackTile) {
            InfinityBackpackTile infinityBackpackTile = (InfinityBackpackTile)tile;
            return infinityBackpackTile.getBackpack();
        }
        return new ItemStack((ItemLike)ModuleTool.INFINITY_BACKPACK.get());
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        Direction direction = (Direction)state.getValue((Property)RotatableBlock.FACING_HORIZONTAL);
        if (direction == Direction.NORTH) {
            return NORTH_SHAPE;
        }
        if (direction == Direction.SOUTH) {
            return SOUTH_SHAPE;
        }
        if (direction == Direction.EAST) {
            return EAST_SHAPE;
        }
        if (direction == Direction.WEST) {
            return WEST_SHAPE;
        }
        return super.getCollisionShape(state, world, pos, selectionContext);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)RotatableBlock.FACING_HORIZONTAL);
        if (direction == Direction.NORTH) {
            return NORTH_SHAPE;
        }
        if (direction == Direction.SOUTH) {
            return SOUTH_SHAPE;
        }
        if (direction == Direction.EAST) {
            return EAST_SHAPE;
        }
        if (direction == Direction.WEST) {
            return WEST_SHAPE;
        }
        return super.getShape(state, level, pos, context);
    }
}

