/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.plugin.curios;

import com.buuz135.industrial.item.infinity.item.ItemInfinityBackpack;
import com.buuz135.industrial.module.ModuleTool;
import com.buuz135.industrial.plugin.CuriosPlugin;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class InfinityBackpackCurios
implements ICurio,
ICurioRenderer {
    public boolean canEquip(SlotContext identifier) {
        return identifier.identifier().equals("back");
    }

    public ItemStack getStack() {
        return new ItemStack((ItemLike)ModuleTool.INFINITY_BACKPACK.get());
    }

    public void curioTick(SlotContext slotContext) {
        LivingEntity livingEntity = slotContext.entity();
        ItemStack stack = CuriosPlugin.getStack(livingEntity, "back", 0);
        if (stack.getItem() instanceof ItemInfinityBackpack) {
            ((Item)ModuleTool.INFINITY_BACKPACK.get()).inventoryTick(stack, livingEntity.level(), (Entity)livingEntity, 0, false);
        }
    }

    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        LivingEntity entity = slotContext.entity();
        ItemStack itemStack = CuriosPlugin.getStack(entity, "back", 0);
        if (itemStack.getItem() instanceof ItemInfinityBackpack) {
            matrixStack.pushPose();
            if (entity.isCrouching()) {
                matrixStack.translate(0.0, 0.2, 0.0);
                matrixStack.mulPose(Axis.XP.rotationDegrees(28.64789f));
            }
            matrixStack.mulPose(Axis.XP.rotationDegrees(180.0f));
            matrixStack.translate(0.0, -0.4, -0.2);
            matrixStack.scale(0.65f, 0.65f, 0.65f);
            Minecraft.getInstance().getItemRenderer().render(itemStack, ItemDisplayContext.FIXED, true, matrixStack, renderTypeBuffer, light, OverlayTexture.NO_OVERLAY, (BakedModel)renderLayerParent.getModel());
            matrixStack.popPose();
        }
    }
}

