/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.proxy.client.particle;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class ParticleVex
extends Particle {
    public static ParticleRenderType RENDER = new ParticleRenderType(){

        @Nullable
        public BufferBuilder begin(Tesselator tesselator, TextureManager textureManager) {
            RenderSystem.setShader(GameRenderer::getPositionColorLightmapShader);
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.lineWidth((float)1.5f);
            return tesselator.begin(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.POSITION_COLOR_LIGHTMAP);
        }
    };
    private final Entity entity;
    private List<Direction> directions;
    private List<Vector3f> lines;
    private boolean isDying = false;

    public ParticleVex(Entity entity) {
        super((ClientLevel)entity.level(), entity.getX() + entity.level().random.nextDouble() - 0.5, entity.getY() + 1.0 + entity.level().random.nextDouble() - 0.5, entity.getZ() + entity.level().random.nextDouble() - 0.5);
        this.entity = entity;
        this.directions = new ArrayList<Direction>();
        Direction prev = Direction.NORTH;
        this.directions.add(0, prev);
        for (int i = 1; i < 50; ++i) {
            prev = this.directions.get(i - 1);
            this.directions.add(i, this.level.random.nextDouble() < 0.05 ? this.getRandomFacing(this.level.random, prev) : prev);
        }
        this.calculateLines();
        this.lifetime = 500;
    }

    public void tick() {
        super.tick();
        Vec3 vec3 = new Vec3(this.x, this.y, this.z);
        if (this.entity.position().distanceToSqr(vec3) > 10.0) {
            this.isDying = true;
        }
        if (!this.isDying && !this.removed) {
            this.directions.add(0, this.level.random.nextDouble() < 0.05 ? this.getRandomFacing(this.level.random, this.directions.get(0)) : this.directions.get(0));
            this.directions.remove(50);
            Vec3 directionVector = new Vec3((double)this.directions.get(0).getNormal().getX(), (double)this.directions.get(0).getNormal().getY(), (double)this.directions.get(0).getNormal().getZ()).scale(0.01);
            this.setPos(this.x - directionVector.x, this.y - directionVector.y, this.z - directionVector.z);
            this.calculateLines();
        } else {
            this.directions.remove(this.directions.size() - 1);
            this.calculateLines();
            if (this.directions.isEmpty()) {
                this.remove();
            }
        }
    }

    public void render(VertexConsumer bufferBad, Camera activeRenderInfo, float v) {
        if (this.entity instanceof LocalPlayer && Minecraft.getInstance().player.getUUID().equals(this.entity.getUUID()) && Minecraft.getInstance().options.getCameraType() == CameraType.FIRST_PERSON) {
            Vec3 vec3 = new Vec3(this.x, this.y, this.z);
            if (this.entity.position().add(0.0, 1.0, 0.0).distanceToSqr(vec3) < 3.0) {
                return;
            }
        }
        BufferBuilder bufferBuilder = RENDER.begin(Tesselator.getInstance(), Minecraft.getInstance().getTextureManager());
        Vec3 vector3d = activeRenderInfo.getPosition();
        float x = (float)(this.entity.xOld + (vector3d.x - this.entity.xOld));
        float y = (float)(this.entity.yOld + (vector3d.y - this.entity.yOld));
        float z = (float)(this.entity.zOld + (vector3d.z - this.entity.zOld));
        for (Vector3f line : this.lines) {
            bufferBuilder.addVertex(line.x - x, line.y - y, line.z - z).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv2(240, 240);
        }
        MeshData mesh = bufferBuilder.build();
        if (mesh != null) {
            BufferUploader.drawWithShader((MeshData)mesh);
        }
    }

    public ParticleRenderType getRenderType() {
        return RENDER;
    }

    private Direction getRandomFacing(RandomSource random, Direction opposite) {
        Direction facing = Direction.getRandom((RandomSource)random);
        while (facing.getOpposite().equals((Object)opposite)) {
            facing = Direction.getRandom((RandomSource)random);
        }
        return facing;
    }

    private void calculateLines() {
        this.lines = new ArrayList<Vector3f>();
        if (this.directions.size() == 0) {
            return;
        }
        Direction prev = this.directions.get(0);
        int currentPosition = 0;
        Vector3f prevBlockPos = new Vector3f((float)this.x, (float)this.y, (float)this.z);
        this.lines.add(prevBlockPos);
        for (int i = 1; i < this.directions.size(); ++i) {
            if (this.directions.get(i).equals((Object)prev) && i != this.directions.size() - 1) continue;
            Vec3 directionVector = new Vec3((double)prev.getNormal().getX(), (double)prev.getNormal().getY(), (double)prev.getNormal().getZ()).scale(0.01);
            Vector3f endBlockPos = new Vector3f((float)((double)prevBlockPos.x + directionVector.x * (double)(i - currentPosition)), (float)((double)prevBlockPos.y + directionVector.y * (double)(i - currentPosition)), (float)((double)prevBlockPos.z + directionVector.z * (double)(i - currentPosition)));
            this.lines.add(endBlockPos);
            prev = this.directions.get(i);
            currentPosition = i;
            prevBlockPos = endBlockPos;
        }
    }
}

