/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.proxy.client.sound;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractSoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TickeableSound
extends AbstractSoundInstance
implements TickableSoundInstance {
    private boolean done;
    private Level world;
    private int distance;
    private float tickIncrease;

    public TickeableSound(Level world, BlockPos pos, SoundEvent soundIn, int distance, int soundTime, RandomSource randomSource) {
        super(soundIn, SoundSource.BLOCKS, randomSource);
        this.world = world;
        this.x = pos.getX();
        this.y = pos.getY();
        this.z = pos.getZ();
        this.looping = false;
        this.done = false;
        this.volume = 0.8f;
        this.pitch = 0.0f;
        this.relative = false;
        this.distance = distance;
        this.tickIncrease = 1.0f / ((float)soundTime * 20.0f);
    }

    public boolean isStopped() {
        return this.done;
    }

    public void setDone() {
        this.done = true;
    }

    public void increase() {
        if (this.pitch < 2.0f) {
            this.pitch += this.tickIncrease;
        }
    }

    public void decrease() {
        if (this.pitch > 0.0f) {
            this.pitch -= this.tickIncrease;
        }
    }

    public void tick() {
        double distance = Minecraft.getInstance().player.blockPosition().distManhattan((Vec3i)new BlockPos((int)this.x, (int)this.y, (int)this.z));
        if (distance > (double)this.distance) {
            this.volume = 0.0f;
        } else {
            if (distance == 0.0) {
                distance = 1.0;
            }
            this.volume = (float)(0.8 * (1.0 - distance / (double)this.distance));
        }
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    public void setDistance(int distance) {
        this.distance = distance;
    }
}

